/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;

public abstract class NumericKeywordValidator
extends KeywordValidator {
    protected final JsonNode number;
    private final boolean isLong;

    protected NumericKeywordValidator(String keyword, JsonNode schema) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
        this.number = schema.get(keyword);
        this.isLong = NumericKeywordValidator.valueIsLong(this.number);
    }

    protected abstract void validateLong(ValidationReport var1, JsonNode var2);

    protected abstract void validateDecimal(ValidationReport var1, JsonNode var2);

    @Override
    public final void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (NumericKeywordValidator.valueIsLong(instance) && this.isLong) {
            this.validateLong(report, instance);
        } else {
            this.validateDecimal(report, instance);
        }
    }

    private static boolean valueIsLong(JsonNode node) {
        return NodeType.getNodeType(node) == NodeType.INTEGER && node.canConvertToLong();
    }

    @Override
    public final String toString() {
        return this.keyword + ": " + this.number;
    }
}

