/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.jackson.JacksonUtils;

public final class DraftV4DependenciesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV4DependenciesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        Map<String, JsonNode> map = JacksonUtils.asMap(schema.get(this.keyword));
        Message.Builder msg = this.newMsg();
        block4: for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            msg.addInfo("property", entry.getKey());
            JsonNode depValue = entry.getValue();
            NodeType type = NodeType.getNodeType(depValue);
            switch (type) {
                case ARRAY: {
                    DraftV4DependenciesSyntaxChecker.checkPropertyDependency(msg, messages, depValue);
                    continue block4;
                }
                case OBJECT: {
                    validator.validate(messages, depValue);
                    continue block4;
                }
            }
            msg.setMessage("incorrect type for dependency value").addInfo("found", type).addInfo("expected", EnumSet.of(NodeType.ARRAY, NodeType.OBJECT));
            messages.add(msg.build());
        }
    }

    private static void checkPropertyDependency(Message.Builder msg, List<Message> messages, JsonNode depValue) {
        int size = depValue.size();
        if (size == 0) {
            msg.setMessage("property dependency array must not be empty");
            messages.add(msg.build());
        }
        HashSet set = Sets.newHashSet();
        for (int index = 0; index < size; ++index) {
            JsonNode node = depValue.get(index);
            NodeType type = NodeType.getNodeType(node);
            if (type != NodeType.STRING) {
                msg.setMessage("incorrect type for property dependency value").addInfo("index", index).addInfo("expected", NodeType.STRING).addInfo("found", type);
                messages.add(msg.build());
            }
            if (set.add(node)) continue;
            msg.setMessage("elements in property array dependency must be unique");
            messages.add(msg.build());
            return;
        }
    }
}

