/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.eel.kitchen.jsonschema.examples.ExampleBase;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.report.ValidationReport;

public final class Example10
extends ExampleBase {
    private static final String URI_BASE = "xxx://foo.bar/path/to/";

    public static void main(String ... args) throws IOException, JsonSchemaException {
        JsonSchemaFactory.Builder builder = JsonSchemaFactory.builder();
        JsonNode node = Example10.loadResource("/split/fstab.json");
        String uri = "xxx://foo.bar/path/to/fstab.json";
        builder.addSchema(uri, node);
        node = Example10.loadResource("/split/mntent.json");
        uri = "xxx://foo.bar/path/to/mntent.json";
        builder.addSchema(uri, node);
        JsonSchemaFactory factory = builder.build();
        JsonSchema schema = factory.fromURI("xxx://foo.bar/path/to/fstab.json");
        JsonNode good = Example10.loadResource("/fstab-good.json");
        JsonNode bad = Example10.loadResource("/fstab-bad.json");
        JsonNode bad2 = Example10.loadResource("/fstab-bad2.json");
        ValidationReport report = schema.validate(good);
        Example10.printReport(report);
        report = schema.validate(bad);
        Example10.printReport(report);
        report = schema.validate(bad2);
        Example10.printReport(report);
    }
}

