/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eel.kitchen.jsonschema.util.jackson.NumberNode;

public final class CustomJsonNodeFactory
extends JsonNodeFactory {
    private static final JsonNodeFactory INSTANCE = new CustomJsonNodeFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).setNodeFactory(INSTANCE);
    private static final ObjectNode EMPTY_OBJECT = INSTANCE.objectNode();

    public static JsonNodeFactory getInstance() {
        return INSTANCE;
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static ObjectNode emptyObject() {
        return EMPTY_OBJECT;
    }

    private CustomJsonNodeFactory() {
    }

    public NumericNode numberNode(byte v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public ValueNode numberNode(Byte value) {
        return new NumberNode((JsonNode)super.numberNode(value));
    }

    public NumericNode numberNode(short v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public ValueNode numberNode(Short value) {
        return new NumberNode((JsonNode)super.numberNode(value));
    }

    public NumericNode numberNode(int v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public ValueNode numberNode(Integer value) {
        return new NumberNode((JsonNode)super.numberNode(value));
    }

    public NumericNode numberNode(long v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public ValueNode numberNode(Long value) {
        return new NumberNode((JsonNode)super.numberNode(value));
    }

    public NumericNode numberNode(BigInteger v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public NumericNode numberNode(float v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public ValueNode numberNode(Float value) {
        return new NumberNode((JsonNode)super.numberNode(value));
    }

    public NumericNode numberNode(double v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }

    public ValueNode numberNode(Double value) {
        return new NumberNode((JsonNode)super.numberNode(value));
    }

    public NumericNode numberNode(BigDecimal v) {
        return new NumberNode((JsonNode)super.numberNode(v));
    }
}

