/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.hyperschema.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.MediaType;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class MediaTypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new MediaTypeSyntaxChecker();

    private MediaTypeSyntaxChecker() {
        super("mediaType", NodeType.STRING, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        String input = schema.get(this.keyword).textValue();
        try {
            MediaType.parse((String)input);
        }
        catch (IllegalArgumentException ignored) {
            msg.setMessage("incorrect media type").addInfo("value", input);
            messages.add(msg.build());
        }
    }
}

