/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class UniqueItemsKeywordValidator
extends KeywordValidator {
    private final boolean uniqueItems;

    public UniqueItemsKeywordValidator(JsonNode schema) {
        super("uniqueItems", NodeType.ARRAY);
        this.uniqueItems = schema.get(this.keyword).booleanValue();
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (!this.uniqueItems) {
            return;
        }
        HashSet set = Sets.newHashSet();
        for (JsonNode element : instance) {
            if (set.add(element)) continue;
            Message.Builder msg = this.newMsg().setMessage("duplicate elements in array");
            report.addMessage(msg.build());
            return;
        }
    }

    @Override
    public boolean alwaysTrue() {
        return !this.uniqueItems;
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.uniqueItems;
    }
}

