/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eel.kitchen.jsonschema.examples.ExampleBase;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.uri.URIDownloader;

public final class Example7
extends ExampleBase {
    public static void main(String ... args) throws IOException, JsonSchemaException {
        JsonNode good = Example7.loadResource("/fstab-good.json");
        JsonNode bad = Example7.loadResource("/fstab-bad.json");
        JsonNode bad2 = Example7.loadResource("/fstab-bad2.json");
        JsonSchemaFactory factory = JsonSchemaFactory.builder().registerScheme("foobar", CustomDownloader.getInstance()).build();
        JsonSchema schema = factory.fromURI("foobar:/fstab-draftv4.json#");
        ValidationReport report = schema.validate(good);
        Example7.printReport(report);
        report = schema.validate(bad);
        Example7.printReport(report);
        report = schema.validate(bad2);
        Example7.printReport(report);
    }

    private static final class CustomDownloader
    implements URIDownloader {
        private static final String PREFIX;
        private static final URIDownloader INSTANCE;

        private CustomDownloader() {
        }

        public static URIDownloader getInstance() {
            return INSTANCE;
        }

        @Override
        public InputStream fetch(URI source) throws IOException {
            String path = PREFIX + source.getPath();
            InputStream ret = this.getClass().getResourceAsStream(path);
            if (ret == null) {
                throw new IOException("resource " + path + " not found");
            }
            return ret;
        }

        static {
            INSTANCE = new CustomDownloader();
            String pkgname = CustomDownloader.class.getPackage().getName();
            PREFIX = '/' + pkgname.replace(".", "/");
        }
    }
}

