/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberNode
extends NumericNode {
    private static final NumericNode ZERO = DecimalNode.valueOf((BigDecimal)BigDecimal.ZERO);
    private final NumericNode node;
    private final int hashCode;

    public NumberNode(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException("only numeric nodes are supported");
        }
        BigDecimal decimal = node.decimalValue();
        if (node.isIntegralNumber()) {
            this.node = (NumericNode)node;
            this.hashCode = decimal.hashCode();
            return;
        }
        Preconditions.checkArgument((node.getClass() == DecimalNode.class ? 1 : 0) != 0, (Object)"only DecimalNode instances are supported for floating point numbers");
        if (BigDecimal.ZERO.compareTo(decimal) == 0) {
            this.node = ZERO;
            this.hashCode = 0;
        } else {
            this.node = (NumericNode)node;
            this.hashCode = decimal.hashCode();
        }
    }

    public JsonParser.NumberType numberType() {
        return this.node.numberType();
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.node.serialize(jgen, provider);
    }

    public Number numberValue() {
        return this.node.numberValue();
    }

    public int intValue() {
        return this.node.intValue();
    }

    public long longValue() {
        return this.node.longValue();
    }

    public double doubleValue() {
        return this.node.doubleValue();
    }

    public BigDecimal decimalValue() {
        return this.node.decimalValue();
    }

    public BigInteger bigIntegerValue() {
        return this.node.bigIntegerValue();
    }

    public boolean canConvertToInt() {
        return this.node.canConvertToInt();
    }

    public boolean canConvertToLong() {
        return this.node.canConvertToLong();
    }

    public String asText() {
        return this.node.asText();
    }

    public JsonToken asToken() {
        return this.node.asToken();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NumericNode otherNode = ((NumberNode)((Object)o)).node;
        if (this.node.isIntegralNumber() && otherNode.isIntegralNumber()) {
            return this.node.equals((Object)otherNode);
        }
        return this.node.decimalValue().equals(otherNode.decimalValue());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.node.toString();
    }
}

