/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final PatternSyntaxChecker instance = new PatternSyntaxChecker();

    public static PatternSyntaxChecker getInstance() {
        return instance;
    }

    private PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        if (RhinoHelper.regexIsValid(value)) {
            return;
        }
        msg.setMessage("pattern is not a valid ECMA 262 regex").addInfo("found", value);
        messages.add(msg.build());
    }
}

