/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class RegexFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new RegexFormatAttribute();

    private RegexFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        if (RhinoHelper.regexIsValid(value.textValue())) {
            return;
        }
        Message.Builder msg = RegexFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a valid ECMA 262 regular expression");
        report.addMessage(msg.build());
    }
}

