/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class SchemaArraySyntaxChecker
extends SimpleSyntaxChecker {
    public SchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (node.size() == 0) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        int index = 0;
        for (JsonNode element : node) {
            NodeType elementType = NodeType.getNodeType(element);
            if (elementType != NodeType.OBJECT) {
                msg.setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", elementType).addInfo("expected", NodeType.OBJECT);
                messages.add(msg.build());
            }
            ++index;
        }
    }
}

