/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class PatternPropertiesSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new PatternPropertiesSyntaxChecker();

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        SortedMap<String, JsonNode> properties = JacksonUtils.nodeToTreeMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : properties.entrySet()) {
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            msg.clearInfo().addInfo("key", key);
            if (!RhinoHelper.regexIsValid(entry.getKey())) {
                msg.setMessage("key is not a valid ECMA 262 regex");
                messages.add(msg.build());
                continue;
            }
            if (value.isObject()) continue;
            msg.setMessage("illegal key value").addInfo("expected", NodeType.OBJECT).addInfo("found", NodeType.getNodeType(value));
            messages.add(msg.build());
        }
    }
}

