/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class RequiredKeywordValidator
extends KeywordValidator {
    private final Set<String> required;

    public RequiredKeywordValidator(JsonNode schema) {
        super("required", NodeType.OBJECT);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : schema.get(this.keyword)) {
            builder.add((Object)element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        HashSet missing = Sets.newHashSet(this.required);
        missing.removeAll(Sets.newHashSet((Iterator)instance.fieldNames()));
        if (missing.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("required property(ies) not found").addInfo("required", Ordering.natural().sortedCopy(this.required)).addInfo("missing", Ordering.natural().sortedCopy((Iterable)missing));
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return "required: " + Ordering.natural().sortedCopy(this.required);
    }
}

