/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class DraftV4TypeKeywordValidator
extends KeywordValidator {
    private final NodeType expected;

    public DraftV4TypeKeywordValidator(JsonNode schema) {
        super("type", NodeType.values());
        this.expected = NodeType.fromName(schema.get(this.keyword).textValue());
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        NodeType type = NodeType.getNodeType(instance);
        if (type == this.expected) {
            return;
        }
        if (type == NodeType.INTEGER && this.expected == NodeType.NUMBER) {
            return;
        }
        Message msg = this.newMsg().setMessage("instance has incorrect type").addInfo("found", type).addInfo("expected", this.expected).build();
        report.addMessage(msg);
    }

    @Override
    public String toString() {
        return "type: " + (Object)((Object)this.expected);
    }
}

