/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class IPV4FormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new IPV4FormatAttribute();
    private static final int IPV4_LENGTH = 4;

    private IPV4FormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 4) {
            return;
        }
        Message.Builder msg = IPV4FormatAttribute.newMsg(fmt).setMessage("string is not a valid IPv4 address").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

