/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.format.FormatBundle;
import org.eel.kitchen.jsonschema.main.ValidationFeature;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class JsonSchema {
    private final JsonValidatorCache cache;
    private final EnumSet<ValidationFeature> features;
    private final FormatBundle formatBundle;
    private final SchemaNode schemaNode;

    JsonSchema(JsonValidatorCache cache, EnumSet<ValidationFeature> features, FormatBundle bundle, SchemaNode schemaNode) {
        this.cache = cache;
        this.features = EnumSet.copyOf(features);
        this.schemaNode = schemaNode;
        this.formatBundle = bundle;
    }

    public ValidationReport validate(JsonNode instance) {
        ValidationContext context = new ValidationContext(this.cache, this.features, this.formatBundle);
        ValidationReport report = new ValidationReport();
        JsonValidator validator = this.cache.getValidator(this.schemaNode);
        validator.validate(context, report, instance);
        return report;
    }
}

