/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class EnumSyntaxChecker
extends SimpleSyntaxChecker {
    private static final SyntaxChecker instance = new EnumSyntaxChecker();

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode enumNode = schema.get(this.keyword);
        if (enumNode.size() == 0) {
            msg.setMessage("an enum array must have at least one element");
            messages.add(msg.build());
            return;
        }
        HashSet values = Sets.newHashSet();
        for (JsonNode value : enumNode) {
            if (values.add(value)) continue;
            msg.setMessage("elements in the array are not unique");
            messages.add(msg.build());
            return;
        }
    }
}

