/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.report.ValidationMessage;

public final class ValidationReport {
    private static final JsonPointer ROOT;
    private static final Ordering<ValidationMessage> MESSAGE_ORDER;
    private final ListMultimap<JsonPointer, ValidationMessage> msgMap = ArrayListMultimap.create();
    private JsonPointer path;
    private boolean fatal = false;

    public ValidationReport() {
        this(ROOT);
    }

    private ValidationReport(JsonPointer path) {
        this.path = path;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public boolean addMessage(ValidationMessage message) {
        if (this.fatal) {
            return true;
        }
        if (message.isFatal()) {
            this.fatal = true;
            this.msgMap.clear();
        }
        this.msgMap.put((Object)this.path, (Object)message);
        return this.fatal;
    }

    public void addMessages(Collection<ValidationMessage> messages) {
        for (ValidationMessage message : messages) {
            if (!this.addMessage(message)) continue;
            return;
        }
    }

    public int size() {
        return this.msgMap.size();
    }

    public boolean isSuccess() {
        return this.msgMap.isEmpty();
    }

    public boolean hasFatalError() {
        return this.fatal;
    }

    public void mergeWith(ValidationReport other) {
        if (this.fatal) {
            return;
        }
        if (other.fatal) {
            this.msgMap.clear();
            this.fatal = true;
        }
        this.msgMap.putAll(other.msgMap);
    }

    public ValidationReport copy() {
        return new ValidationReport(this.path);
    }

    public List<String> getMessages() {
        List paths = Ordering.natural().sortedCopy((Iterable)this.msgMap.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonPointer path : paths) {
            List messages = MESSAGE_ORDER.sortedCopy((Iterable)this.msgMap.get((Object)path));
            for (ValidationMessage msg : messages) {
                builder.add((Object)(path + ": " + msg));
            }
        }
        return builder.build();
    }

    public JsonNode asJsonObject() {
        ObjectNode ret = JsonNodeFactory.instance.objectNode();
        for (JsonPointer ptr : this.msgMap.keySet()) {
            ArrayNode node = JsonNodeFactory.instance.arrayNode();
            List messages = MESSAGE_ORDER.sortedCopy((Iterable)this.msgMap.get((Object)ptr));
            for (ValidationMessage message : messages) {
                node.add(message.toJsonNode());
            }
            ret.put(ptr.toString(), (JsonNode)node);
        }
        return ret;
    }

    public JsonNode asJsonArray() {
        ArrayNode ret = JsonNodeFactory.instance.arrayNode();
        List paths = Ordering.natural().sortedCopy((Iterable)this.msgMap.keySet());
        for (JsonPointer ptr : paths) {
            List messages = MESSAGE_ORDER.sortedCopy((Iterable)this.msgMap.get((Object)ptr));
            for (ValidationMessage msg : messages) {
                ObjectNode node = JsonNodeFactory.instance.objectNode().put("path", ptr.toString());
                node.putAll((ObjectNode)msg.toJsonNode());
                ret.add((JsonNode)node);
            }
        }
        return ret;
    }

    public String toString() {
        return "current path: \"" + this.path + "\"; " + this.msgMap.size() + " messages";
    }

    @Deprecated
    public JsonNode asJsonNode() {
        return this.asJsonObject();
    }

    static {
        MESSAGE_ORDER = Ordering.from((Comparator)MessageComparator.instance);
        try {
            ROOT = new JsonPointer("");
        }
        catch (JsonSchemaException e) {
            throw new RuntimeException("WTF??", e);
        }
    }

    private static class MessageComparator
    implements Comparator<ValidationMessage> {
        private static final Comparator<ValidationMessage> instance = new MessageComparator();

        private MessageComparator() {
        }

        @Override
        public int compare(ValidationMessage msg1, ValidationMessage msg2) {
            int ret = msg1.getDomain().compareTo(msg2.getDomain());
            if (ret != 0) {
                return ret;
            }
            ret = msg1.getKeyword().compareTo(msg2.getKeyword());
            if (ret != 0) {
                return ret;
            }
            return msg1.getMessage().compareTo(msg2.getMessage());
        }
    }
}

