/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.ref.SchemaContainer;
import org.eel.kitchen.jsonschema.ref.SchemaNode;
import org.eel.kitchen.jsonschema.ref.SchemaRegistry;
import org.eel.kitchen.jsonschema.report.ValidationDomain;
import org.eel.kitchen.jsonschema.report.ValidationMessage;

final class JsonResolver {
    private final SchemaRegistry registry;

    JsonResolver(SchemaRegistry registry) {
        this.registry = registry;
    }

    SchemaNode resolve(SchemaNode schemaNode) throws JsonSchemaException {
        JsonNode refNode;
        ValidationMessage.Builder msg = new ValidationMessage.Builder(ValidationDomain.REF_RESOLVING).setKeyword("$ref").setFatal(true);
        SchemaContainer container = schemaNode.getContainer();
        JsonNode node = schemaNode.getNode();
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        while ((refNode = node.path("$ref")).isTextual()) {
            JsonRef ref;
            try {
                ref = JsonRef.fromString(refNode.textValue());
            }
            catch (JsonSchemaException ignored) {
                break;
            }
            JsonRef source = container.getLocator();
            JsonRef target = source.resolve(ref);
            if (!refs.add(target)) {
                msg.setMessage("ref loop detected").addInfo("path", refs);
                throw new JsonSchemaException(msg.build());
            }
            if (!source.contains(target)) {
                container = this.registry.get(target.getRootAsURI());
            }
            if (!(node = target.getFragment().resolve(container.getSchema())).isMissingNode()) continue;
            msg.setMessage("dangling JSON Reference").addInfo("ref", target);
            throw new JsonSchemaException(msg.build());
        }
        return new SchemaNode(container, node);
    }
}

