/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.PositiveIntegerKeywordValidator;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class MinLengthKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MinLengthKeywordValidator(JsonNode schema) {
        super("minLength", schema, NodeType.STRING);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        int len = instance.textValue().length();
        if (len >= this.intValue) {
            return;
        }
        ValidationMessage.Builder msg = this.newMsg().addInfo(this.keyword, this.intValue).addInfo("found", len).setMessage("string is too short");
        report.addMessage(msg.build());
    }
}

