/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.uri;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.report.ValidationDomain;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.uri.DefaultURIDownloader;
import org.eel.kitchen.jsonschema.uri.ResourceURIDownloader;
import org.eel.kitchen.jsonschema.uri.URIDownloader;

public class URIManager {
    private static final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private final Map<String, URIDownloader> downloaders = new HashMap<String, URIDownloader>();
    private final Map<URI, URI> URIRedirections = Maps.newHashMap();

    public URIManager() {
        this.downloaders.put("http", DefaultURIDownloader.getInstance());
        this.downloaders.put("ftp", DefaultURIDownloader.getInstance());
        this.downloaders.put("file", DefaultURIDownloader.getInstance());
        this.downloaders.put("jar", DefaultURIDownloader.getInstance());
        this.downloaders.put("resource", ResourceURIDownloader.getInstance());
    }

    public void registerScheme(String scheme, URIDownloader downloader) {
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme is null");
        Preconditions.checkArgument((!scheme.isEmpty() ? 1 : 0) != 0, (Object)"scheme is empty");
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new IllegalArgumentException("illegal scheme \"" + scheme + '\"');
        }
        this.downloaders.put(scheme, downloader);
    }

    public void unregisterScheme(String scheme) {
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme is null");
        this.downloaders.remove(scheme);
    }

    public void addRedirection(String from, String to) {
        URI destURI;
        URI sourceURI;
        try {
            sourceURI = JsonRef.fromString(from).getRootAsURI();
        }
        catch (JsonSchemaException ignored) {
            throw new IllegalArgumentException("source URI " + from + " is not an absolute JSON Reference");
        }
        try {
            destURI = JsonRef.fromString(to).getRootAsURI();
        }
        catch (JsonSchemaException ignored) {
            throw new IllegalArgumentException("destination URI " + to + " is not an absolute JSON Reference");
        }
        this.URIRedirections.put(sourceURI, destURI);
    }

    public JsonNode getContent(URI uri) throws JsonSchemaException {
        InputStream in;
        Preconditions.checkNotNull((Object)uri, (Object)"null URI");
        Preconditions.checkArgument((boolean)uri.isAbsolute(), (Object)("requested URI (" + uri + ") is not absolute"));
        URI target = this.URIRedirections.containsKey(uri) ? this.URIRedirections.get(uri) : uri;
        String scheme = target.getScheme();
        ValidationMessage.Builder msg = new ValidationMessage.Builder(ValidationDomain.REF_RESOLVING).setKeyword("N/A").addInfo("uri", target);
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            msg.setMessage("cannot handle scheme").addInfo("scheme", scheme);
            throw new JsonSchemaException(msg.build());
        }
        try {
            in = downloader.fetch(target);
        }
        catch (IOException e) {
            msg.setMessage("cannot fetch content from URI");
            throw new JsonSchemaException(msg.build(), e);
        }
        try {
            return mapper.readTree(in);
        }
        catch (IOException e) {
            msg.setMessage("content fetched from URI is not valid JSON");
            throw new JsonSchemaException(msg.build(), e);
        }
    }
}

