/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.report.ValidationDomain;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.JacksonUtils;

public final class SyntaxValidator {
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxValidator(KeywordBundle bundle) {
        this.checkers = ImmutableMap.copyOf(bundle.getSyntaxCheckers());
    }

    public void validate(List<ValidationMessage> messages, JsonNode schema) {
        Set<String> keywords = JacksonUtils.fieldNames(schema);
        keywords.retainAll(this.checkers.keySet());
        for (String keyword : keywords) {
            ValidationMessage.Builder msg = new ValidationMessage.Builder(ValidationDomain.SYNTAX).setKeyword(keyword);
            SyntaxChecker checker = this.checkers.get(keyword);
            checker.checkSyntax(msg, messages, schema);
        }
    }
}

