/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.eel.kitchen.jsonschema.format.DateTimeFormatSpecifier;
import org.eel.kitchen.jsonschema.format.EmailFormatSpecifier;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.format.HostnameFormatSpecifier;
import org.eel.kitchen.jsonschema.format.IPV4FormatSpecifier;
import org.eel.kitchen.jsonschema.format.IPV6FormatSpecifier;
import org.eel.kitchen.jsonschema.format.RegexFormatSpecifier;
import org.eel.kitchen.jsonschema.format.URIFormatSpecifier;

public final class FormatBundle {
    private static final Map<String, FormatSpecifier> BUILTIN_FORMATS;
    private final Map<String, FormatSpecifier> specifiers;

    private FormatBundle() {
        this(Collections.emptyMap());
    }

    private FormatBundle(Map<String, FormatSpecifier> specifiers) {
        this.specifiers = Maps.newHashMap(specifiers);
    }

    public static FormatBundle newBundle() {
        return new FormatBundle();
    }

    public static FormatBundle defaultBundle() {
        return new FormatBundle(BUILTIN_FORMATS);
    }

    public void registerFormat(String fmt, FormatSpecifier specifier) {
        this.specifiers.put(fmt, specifier);
    }

    public void unregisterFormat(String fmt) {
        this.specifiers.remove(fmt);
    }

    public void mergeWith(FormatBundle other) {
        this.specifiers.putAll(other.specifiers);
    }

    public Map<String, FormatSpecifier> getSpecifiers() {
        return ImmutableMap.copyOf(this.specifiers);
    }

    public String toString() {
        return "specifiers: " + this.specifiers.keySet();
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"date-time", (Object)DateTimeFormatSpecifier.getInstance());
        builder.put((Object)"email", (Object)EmailFormatSpecifier.getInstance());
        builder.put((Object)"host-name", (Object)HostnameFormatSpecifier.getInstance());
        builder.put((Object)"ip-address", (Object)IPV4FormatSpecifier.getInstance());
        builder.put((Object)"ipv6", (Object)IPV6FormatSpecifier.getInstance());
        builder.put((Object)"regex", (Object)RegexFormatSpecifier.getInstance());
        builder.put((Object)"uri", (Object)URIFormatSpecifier.getInstance());
        BUILTIN_FORMATS = builder.build();
    }
}

