/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.SchemaNode;
import org.eel.kitchen.jsonschema.validator.SyntaxJsonValidator;

public final class RefResolverJsonValidator
extends JsonValidator {
    public RefResolverJsonValidator(JsonSchemaFactory factory, SchemaNode schemaNode) {
        super(factory, schemaNode);
    }

    @Override
    public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        JsonNode refNode;
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        SchemaContainer container = context.getContainer();
        JsonNode node = this.schemaNode.getNode();
        while ((refNode = node.path("$ref")).isTextual()) {
            JsonRef ref;
            try {
                ref = JsonRef.fromString(refNode.textValue());
            }
            catch (JsonSchemaException ignored) {
                break;
            }
            JsonRef source = container.getLocator();
            JsonRef target = source.resolve(ref);
            if (!refs.add(target)) {
                report.addMessage("ref loop detected: " + refs);
                return false;
            }
            if (!source.contains(target)) {
                try {
                    container = this.factory.getSchema(target.getRootAsURI());
                    context.setContainer(container);
                    this.schemaNode.setContainer(container);
                }
                catch (JsonSchemaException e) {
                    report.addMessage(e.getMessage());
                    return false;
                }
            }
            if ((node = target.getFragment().resolve(container.getSchema())).isMissingNode()) {
                report.addMessage("dangling JSON Ref: " + target);
                return false;
            }
            this.schemaNode.setNode(node);
        }
        return true;
    }

    @Override
    public JsonValidator next() {
        return new SyntaxJsonValidator(this.factory, this.schemaNode);
    }
}

