/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class UniqueItemsKeywordValidator
extends KeywordValidator {
    private final boolean uniqueItems;

    public UniqueItemsKeywordValidator(JsonNode schema) {
        super("uniqueItems", NodeType.ARRAY);
        this.uniqueItems = schema.get(this.keyword).booleanValue();
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (!this.uniqueItems) {
            return;
        }
        HashSet<JsonNode> set = new HashSet<JsonNode>();
        for (JsonNode element : instance) {
            if (set.add(element)) continue;
            report.addMessage("elements in array must be unique");
            return;
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.uniqueItems;
    }
}

