/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.util.ArgumentChecker;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public final class URIUtils {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final CharMatcher ALPHA = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).precomputed();
    private static final CharMatcher SCHEME_LEGAL = ALPHA.or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"+-.")).precomputed();
    private static final Function<String, String> LOWERCASE = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            return input == null ? null : input.toLowerCase();
        }
    };
    private static final Function<URI, URI> URI_NORMALIZER = new Function<URI, URI>(){

        @Nullable
        public URI apply(@Nullable URI input) {
            if (input == null) {
                return null;
            }
            URI uri = input.normalize();
            String scheme = uri.getScheme();
            String host = uri.getHost();
            if (scheme == null && host == null) {
                return uri;
            }
            if (uri.isOpaque()) {
                try {
                    return new URI((String)LOWERCASE.apply((Object)scheme), uri.getSchemeSpecificPart(), uri.getFragment());
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("How did I get there??", e);
                }
            }
            String userinfo = uri.getUserInfo();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            String fragment = uri.getFragment();
            try {
                return new URI((String)LOWERCASE.apply((Object)scheme), userinfo, (String)LOWERCASE.apply((Object)host), port, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("How did I get there??", e);
            }
        }
    };
    private static final Function<URI, URI> SCHEMAURI_NORMALIZER = new Function<URI, URI>(){

        @Nullable
        public URI apply(@Nullable URI input) {
            URI uri = (URI)URI_NORMALIZER.apply((Object)input);
            if (uri == null) {
                return null;
            }
            try {
                return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), (String)Optional.fromNullable((Object)uri.getFragment()).or((Object)""));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("How did I get there??", e);
            }
        }
    };
    private static final ArgumentChecker<String> SCHEME_CHECKER = new ArgumentChecker<String>(){

        @Override
        public void check(String argument) {
            if (argument.isEmpty() || !ALPHA.matches(argument.charAt(0)) || !SCHEME_LEGAL.matchesAllOf((CharSequence)argument)) {
                throw new IllegalArgumentException(BUNDLE.printf("loadingCfg.illegalScheme", new Object[]{argument}));
            }
        }
    };
    private static final ArgumentChecker<URI> PATHURI_CHECKER = new ArgumentChecker<URI>(){

        @Override
        public void check(URI argument) {
            BUNDLE.checkArgumentPrintf(argument.isAbsolute(), "uriChecks.notAbsolute", new Object[]{argument});
            BUNDLE.checkArgumentPrintf(argument.getFragment() == null, "uriChecks.fragmentNotNull", new Object[]{argument});
            BUNDLE.checkArgumentPrintf(argument.getQuery() == null, "uriChecks.queryNotNull", new Object[]{argument});
            BUNDLE.checkArgumentPrintf(argument.getPath() != null, "uriChecks.noPath", new Object[]{argument});
            BUNDLE.checkArgumentPrintf(argument.getPath().endsWith("/"), "uriChecks.noEndingSlash", new Object[]{argument});
        }
    };
    private static final ArgumentChecker<URI> SCHEMAURI_CHECKER = new ArgumentChecker<URI>(){

        @Override
        public void check(URI argument) {
            BUNDLE.checkArgumentPrintf(argument.isAbsolute(), "uriChecks.notAbsolute", new Object[]{argument});
            JsonRef ref = JsonRef.fromURI(argument);
            BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "uriChecks.notAbsoluteRef", new Object[]{argument});
            BUNDLE.checkArgumentPrintf(!argument.getPath().endsWith("/"), "uriChecks.endingSlash", new Object[]{argument});
        }
    };

    private URIUtils() {
    }

    public static Function<String, String> schemeNormalizer() {
        return LOWERCASE;
    }

    public static String normalizeScheme(@Nullable String scheme) {
        return (String)LOWERCASE.apply((Object)scheme);
    }

    public static Function<URI, URI> uriNormalizer() {
        return URI_NORMALIZER;
    }

    public static URI normalizeURI(@Nullable URI uri) {
        return (URI)URI_NORMALIZER.apply((Object)uri);
    }

    public static Function<URI, URI> schemaURINormalizer() {
        return SCHEMAURI_NORMALIZER;
    }

    public static URI normalizeSchemaURI(@Nullable URI uri) {
        return (URI)SCHEMAURI_NORMALIZER.apply((Object)uri);
    }

    public static ArgumentChecker<String> schemeChecker() {
        return SCHEME_CHECKER;
    }

    public static void checkScheme(String scheme) {
        SCHEME_CHECKER.check(scheme);
    }

    public static ArgumentChecker<URI> pathURIChecker() {
        return PATHURI_CHECKER;
    }

    public static void checkPathURI(URI uri) {
        PATHURI_CHECKER.check(uri);
    }

    public static ArgumentChecker<URI> schemaURIChecker() {
        return SCHEMAURI_CHECKER;
    }

    public static void checkSchemaURI(URI uri) {
        SCHEMAURI_CHECKER.check(uri);
    }
}

