/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.tree;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.key.SchemaKey;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public abstract class BaseSchemaTree
implements SchemaTree {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected final SchemaKey key;
    private final JsonRef dollarSchema;
    protected final JsonNode baseNode;
    protected final JsonPointer pointer;
    private final JsonNode node;
    private final JsonRef startingRef;
    private final JsonRef currentRef;

    protected BaseSchemaTree(SchemaKey key, JsonNode baseNode, JsonPointer pointer) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)baseNode);
        Preconditions.checkNotNull((Object)pointer);
        this.key = key;
        this.dollarSchema = BaseSchemaTree.extractDollarSchema(baseNode);
        this.baseNode = baseNode;
        this.pointer = pointer;
        this.node = (JsonNode)pointer.path((TreeNode)baseNode);
        JsonRef loadingRef = key.getLoadingRef();
        JsonRef ref = BaseSchemaTree.idFromNode(baseNode);
        this.startingRef = ref == null ? loadingRef : loadingRef.resolve(ref);
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, pointer, baseNode);
    }

    @Deprecated
    protected BaseSchemaTree(JsonRef loadingRef, JsonNode baseNode, JsonPointer pointer) {
        this.dollarSchema = BaseSchemaTree.extractDollarSchema(baseNode);
        this.key = loadingRef.equals(JsonRef.emptyRef()) ? SchemaKey.anonymousKey() : SchemaKey.forJsonRef(loadingRef);
        this.baseNode = baseNode;
        this.pointer = pointer;
        this.node = (JsonNode)pointer.path((TreeNode)baseNode);
        JsonRef ref = BaseSchemaTree.idFromNode(baseNode);
        this.startingRef = ref == null ? loadingRef : loadingRef.resolve(ref);
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, pointer, baseNode);
    }

    protected BaseSchemaTree(BaseSchemaTree other, JsonPointer newPointer) {
        this.key = other.key;
        this.dollarSchema = other.dollarSchema;
        this.baseNode = other.baseNode;
        this.pointer = newPointer;
        this.node = (JsonNode)newPointer.path((TreeNode)this.baseNode);
        this.startingRef = other.startingRef;
        this.currentRef = BaseSchemaTree.nextRef(this.startingRef, newPointer, this.baseNode);
    }

    @Override
    @Deprecated
    public final long getId() {
        return this.key.getId();
    }

    @Override
    public final JsonNode getBaseNode() {
        return this.baseNode;
    }

    @Override
    public final JsonPointer getPointer() {
        return this.pointer;
    }

    @Override
    public final JsonNode getNode() {
        return this.node;
    }

    @Override
    public final JsonRef resolve(JsonRef other) {
        return this.currentRef.resolve(other);
    }

    @Override
    public final JsonRef getDollarSchema() {
        return this.dollarSchema;
    }

    @Override
    public final JsonRef getLoadingRef() {
        return this.key.getLoadingRef();
    }

    @Override
    public final JsonRef getContext() {
        return this.currentRef;
    }

    @Override
    public final JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("loadingURI", (JsonNode)FACTORY.textNode(this.key.getLoadingRef().toString()));
        ret.put("pointer", (JsonNode)FACTORY.textNode(this.pointer.toString()));
        return ret;
    }

    @Nonnull
    public final String toString() {
        return this.getClass().getSimpleName() + "{" + "key" + "=" + this.key + ", pointer" + "=" + this.pointer + ", URI context" + "=" + this.currentRef + "}";
    }

    public final int hashCode() {
        return this.key.hashCode() ^ this.pointer.hashCode();
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseSchemaTree other = (BaseSchemaTree)obj;
        return this.key.equals(other.key) && this.pointer.equals((Object)other.pointer);
    }

    @Nullable
    protected static JsonRef idFromNode(JsonNode node) {
        if (!node.path("id").isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(node.get("id").textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    private static JsonRef nextRef(JsonRef startingRef, JsonPointer ptr, JsonNode startingNode) {
        TokenResolver resolver;
        JsonRef ret = startingRef;
        JsonNode node = startingNode;
        Iterator iterator = ptr.iterator();
        while (iterator.hasNext() && (node = (JsonNode)(resolver = (TokenResolver)iterator.next()).get((TreeNode)node)) != null) {
            JsonRef idRef = BaseSchemaTree.idFromNode(node);
            if (idRef == null) continue;
            ret = ret.resolve(idRef);
        }
        return ret;
    }

    private static JsonRef extractDollarSchema(JsonNode schema) {
        JsonNode node = schema.path("$schema");
        if (!node.isTextual()) {
            return JsonRef.emptyRef();
        }
        try {
            JsonRef ref = JsonRef.fromString(node.textValue());
            return ref.isAbsolute() ? ref : JsonRef.emptyRef();
        }
        catch (JsonReferenceException ignored) {
            return JsonRef.emptyRef();
        }
    }
}

