/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.processing.RawProcessor;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.SchemaListenerFactory;
import com.github.fge.jsonschema.walk.SchemaWalker;
import com.github.fge.jsonschema.walk.SchemaWalkerFactory;

public final class SchemaWalkerProcessor<T>
extends RawProcessor<SchemaTree, T> {
    private final SchemaWalkerFactory walkerFactory;
    private final SchemaListenerFactory<T> listenerFactory;

    public SchemaWalkerProcessor(SchemaWalkerFactory walkerFactory, SchemaListenerFactory<T> listenerFactory) {
        super("schema", "value");
        this.walkerFactory = walkerFactory;
        this.listenerFactory = listenerFactory;
    }

    @Override
    public T rawProcess(ProcessingReport report, SchemaTree input) throws ProcessingException {
        SchemaWalker walker = this.walkerFactory.newWalker(input);
        SchemaListener<T> listener = this.listenerFactory.newListener();
        walker.walk(listener, report);
        return listener.getValue();
    }
}

