/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.SchemaWalkingConfiguration;
import com.github.fge.jsonschema.walk.collectors.PointerCollector;
import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

@Beta
public abstract class SchemaWalker {
    protected SchemaTree tree;
    private final Map<String, PointerCollector> collectors;

    protected SchemaWalker(SchemaTree tree, SchemaWalkingConfiguration cfg) {
        this.tree = tree;
        this.collectors = cfg.collectors.entries();
    }

    public final <T> void walk(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        this.walkTree(JsonPointer.empty(), this.tree, listener, report);
    }

    protected abstract SchemaTree resolveTree(SchemaTree var1, ProcessingReport var2) throws ProcessingException;

    private <T> void walkTree(JsonPointer pwd, SchemaTree tree, SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        listener.enteringPath(pwd, report);
        SchemaTree resolvedTree = this.resolveTree(tree, report);
        listener.visiting(resolvedTree, report);
        TreeMap map = Maps.newTreeMap();
        map.putAll(this.collectors);
        map.keySet().retainAll(Sets.newHashSet((Iterator)resolvedTree.getNode().fieldNames()));
        ArrayList pointers = Lists.newArrayList();
        for (PointerCollector collector : map.values()) {
            collector.collect(pointers, resolvedTree);
        }
        for (JsonPointer ptr : pointers) {
            this.walkTree(pwd.append(ptr), resolvedTree.append(ptr), listener, report);
        }
        listener.exitingPath(pwd, report);
    }

    public abstract String toString();
}

