/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.helpers;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;

public final class URISyntaxChecker
extends AbstractSyntaxChecker {
    public URISyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String s = this.getNode(tree).textValue();
        try {
            URI uri = new URI(s);
            if (!uri.equals(uri.normalize())) {
                report.error(this.newMsg(tree, bundle, "common.uri.notNormalized").putArgument("value", s));
            }
        }
        catch (URISyntaxException ignored) {
            report.error(this.newMsg(tree, bundle, "common.uri.invalid").putArgument("value", s));
        }
    }
}

