/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;

public final class RequiredSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private static final SyntaxChecker INSTANCE = new RequiredSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private RequiredSyntaxChecker() {
        super("required", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        int size = node.size();
        if (size == 0) {
            report.error(this.newMsg(tree, bundle, "common.array.empty"));
            return;
        }
        HashSet set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            uniqueElements = set.add(EQUIVALENCE.wrap((Object)element));
            NodeType type = NodeType.getNodeType((JsonNode)element);
            if (type == NodeType.STRING) continue;
            report.error(this.newMsg(tree, bundle, "common.array.element.incorrectType").putArgument("index", index).putArgument("expected", EnumSet.of(NodeType.STRING)).putArgument("found", type));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, bundle, "common.array.duplicateElements"));
        }
    }
}

