/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.RhinoHelper;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;

public final class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String value = this.getNode(tree).textValue();
        if (!RhinoHelper.regexIsValid(value)) {
            report.error(this.newMsg(tree, bundle, "common.invalidRegex").putArgument("value", value));
        }
    }
}

