/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.ValueHolder;

public abstract class RawProcessor<IN, OUT>
implements Processor<ValueHolder<IN>, ValueHolder<OUT>> {
    private final String inputName;
    private final String outputName;

    protected RawProcessor(String inputName, String outputName) {
        this.inputName = inputName;
        this.outputName = outputName;
    }

    protected abstract OUT rawProcess(ProcessingReport var1, IN var2) throws ProcessingException;

    @Override
    public final ValueHolder<OUT> process(ProcessingReport report, ValueHolder<IN> input) throws ProcessingException {
        IN rawInput = input.getValue();
        OUT rawOutput = this.rawProcess(report, rawInput);
        return ValueHolder.hold(this.outputName, rawOutput);
    }

    protected final ProcessingMessage newMessage(IN rawInput) {
        return new ProcessingMessage().put(this.inputName, rawInput);
    }
}

