/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load.uri;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.load.uri.URITransformer;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class URITransformerBuilder
implements Thawed<URITransformer> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final URI EMPTY = URI.create("");
    URI namespace = EMPTY;
    final Map<URI, URI> pathRedirects = Maps.newHashMap();
    final Map<URI, URI> schemaRedirects = Maps.newHashMap();

    URITransformerBuilder() {
    }

    URITransformerBuilder(URITransformer transformer) {
        this.namespace = transformer.namespace;
        this.pathRedirects.putAll(transformer.pathRedirects);
        this.schemaRedirects.putAll(transformer.schemaRedirects);
    }

    public URITransformerBuilder setNamespace(URI uri) {
        BUNDLE.checkNotNull((Object)uri, "uriTransform.nullInput");
        this.namespace = URITransformerBuilder.toPathURI(uri);
        return this;
    }

    public URITransformerBuilder setNamespace(String uri) {
        BUNDLE.checkNotNull((Object)uri, "uriTransform.nullInput");
        return this.setNamespace(URI.create(uri));
    }

    public URITransformerBuilder addSchemaRedirect(URI from, URI to) {
        BUNDLE.checkNotNull((Object)from, "uriTransform.nullInput");
        BUNDLE.checkNotNull((Object)to, "uriTransform.nullInput");
        URI key = URITransformerBuilder.toSchemaURI(from);
        URI value = URITransformerBuilder.toSchemaURI(to);
        if (!key.equals(value)) {
            this.schemaRedirects.put(key, value);
        }
        return this;
    }

    public URITransformerBuilder addSchemaRedirect(String from, String to) {
        BUNDLE.checkNotNull((Object)from, "uriTransform.nullInput");
        BUNDLE.checkNotNull((Object)to, "uriTransform.nullInput");
        URI src = URI.create(from);
        URI dst = URI.create(to);
        return this.addSchemaRedirect(src, dst);
    }

    public URITransformerBuilder addPathRedirect(URI from, URI to) {
        BUNDLE.checkNotNull((Object)from, "uriTransform.nullInput");
        BUNDLE.checkNotNull((Object)to, "uriTransform.nullInput");
        URI key = URITransformerBuilder.toPathURI(from);
        URI value = URITransformerBuilder.toPathURI(to);
        if (!key.equals(value)) {
            this.pathRedirects.put(key, value);
        }
        return this;
    }

    public URITransformerBuilder addPathRedirect(String from, String to) {
        BUNDLE.checkNotNull((Object)from, "uriTransform.nullInput");
        BUNDLE.checkNotNull((Object)to, "uriTransform.nullInput");
        URI src = URI.create(from);
        URI dst = URI.create(to);
        return this.addPathRedirect(src, dst);
    }

    public URITransformer freeze() {
        return new URITransformer(this);
    }

    private static URI toSchemaURI(URI uri) {
        URI normalized = uri.normalize();
        BUNDLE.checkArgumentPrintf(normalized.isAbsolute(), "uriTransform.notAbsolute", new Object[]{uri});
        JsonRef ref = JsonRef.fromURI(normalized);
        BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "uriTransform.notAbsoluteRef", new Object[]{uri});
        BUNDLE.checkArgumentPrintf(!normalized.getPath().endsWith("/"), "uriTransform.endingSlash", new Object[]{uri});
        return ref.getLocator();
    }

    private static URI toPathURI(URI uri) {
        URI normalized = uri.normalize();
        BUNDLE.checkArgumentPrintf(normalized.isAbsolute(), "uriTransform.notAbsolute", new Object[]{uri});
        BUNDLE.checkArgumentPrintf(uri.getFragment() == null, "uriTransform.fragmentNotNull", new Object[]{uri});
        BUNDLE.checkArgumentPrintf(uri.getQuery() == null, "uriTransform.queryNotNull", new Object[]{uri});
        BUNDLE.checkArgumentPrintf(uri.getPath().endsWith("/"), "uriTransform.noEndingSlash", new Object[]{uri});
        return normalized;
    }
}

