/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load.uri;

import com.github.fge.Frozen;
import com.github.fge.jsonschema.load.uri.URITransformerBuilder;
import com.github.fge.jsonschema.ref.JsonRef;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class URITransformer
implements Frozen<URITransformerBuilder> {
    final URI namespace;
    final Map<URI, URI> pathRedirects;
    final Map<URI, URI> schemaRedirects;

    public static URITransformerBuilder newBuilder() {
        return new URITransformerBuilder();
    }

    public static URITransformer byDefault() {
        return new URITransformerBuilder().freeze();
    }

    URITransformer(URITransformerBuilder builder) {
        this.namespace = builder.namespace;
        this.pathRedirects = ImmutableMap.copyOf(builder.pathRedirects);
        this.schemaRedirects = ImmutableMap.copyOf(builder.schemaRedirects);
    }

    public URI transform(URI source) {
        URI uri = this.namespace.resolve(source).normalize();
        String fragment = uri.getFragment();
        try {
            uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("How did I get there??", e);
        }
        for (Map.Entry<URI, URI> entry : this.pathRedirects.entrySet()) {
            URI relative = entry.getKey().relativize(uri);
            if (relative.equals(uri)) continue;
            uri = entry.getValue().resolve(relative);
        }
        if (this.schemaRedirects.containsKey(uri = JsonRef.fromURI(uri).getLocator())) {
            uri = this.schemaRedirects.get(uri);
        }
        try {
            return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("How did I get there??", e);
        }
    }

    public URITransformerBuilder thaw() {
        return new URITransformerBuilder(this);
    }
}

