/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.Thawed;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.load.DefaultDownloadersDictionary;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.load.uri.URITransformer;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;

public final class LoadingConfigurationBuilder
implements Thawed<LoadingConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final EnumSet<JsonParser.Feature> DEFAULT_PARSER_FEATURES;
    final DictionaryBuilder<URIDownloader> downloaders;
    URITransformer transformer;
    Dereferencing dereferencing;
    final Map<URI, JsonNode> preloadedSchemas;
    final EnumSet<JsonParser.Feature> parserFeatures;

    LoadingConfigurationBuilder() {
        this.downloaders = DefaultDownloadersDictionary.get().thaw();
        this.transformer = URITransformer.byDefault();
        this.dereferencing = Dereferencing.CANONICAL;
        this.preloadedSchemas = Maps.newHashMap();
        for (SchemaVersion version : SchemaVersion.values()) {
            this.preloadedSchemas.put(version.getLocation(), version.getSchema());
        }
        this.parserFeatures = EnumSet.copyOf(DEFAULT_PARSER_FEATURES);
    }

    LoadingConfigurationBuilder(LoadingConfiguration cfg) {
        this.downloaders = cfg.downloaders.thaw();
        this.transformer = cfg.transformer;
        this.dereferencing = cfg.dereferencing;
        this.preloadedSchemas = Maps.newHashMap(cfg.preloadedSchemas);
        this.parserFeatures = EnumSet.copyOf(cfg.parserFeatures);
    }

    public LoadingConfigurationBuilder addScheme(String scheme, URIDownloader downloader) {
        this.downloaders.addEntry(LoadingConfigurationBuilder.checkScheme(scheme), downloader);
        return this;
    }

    public LoadingConfigurationBuilder removeScheme(String scheme) {
        this.downloaders.removeEntry(scheme);
        return this;
    }

    public LoadingConfigurationBuilder setURITransformer(URITransformer transformer) {
        this.transformer = (URITransformer)BUNDLE.checkNotNull((Object)transformer, "loadingCfg.nullURITransformer");
        return this;
    }

    @Deprecated
    public LoadingConfigurationBuilder setNamespace(String input) {
        this.transformer = this.transformer.thaw().setNamespace(input).freeze();
        return this;
    }

    public LoadingConfigurationBuilder dereferencing(Dereferencing dereferencing) {
        BUNDLE.checkNotNull((Object)dereferencing, "loadingCfg.nullDereferencingMode");
        this.dereferencing = dereferencing;
        return this;
    }

    @Deprecated
    public LoadingConfigurationBuilder addSchemaRedirect(String source, String destination) {
        this.transformer = this.transformer.thaw().addSchemaRedirect(source, destination).freeze();
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(String uri, JsonNode schema) {
        BUNDLE.checkNotNull((Object)schema, "loadingCfg.nullSchema");
        URI key = LoadingConfigurationBuilder.getLocator(uri);
        BUNDLE.checkArgumentPrintf(this.preloadedSchemas.put(key, schema) == null, "loadingCfg.duplicateURI", new Object[]{key});
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(JsonNode schema) {
        JsonNode node = schema.path("id");
        BUNDLE.checkArgument(node.isTextual(), "loadingCfg.noIDInSchema");
        return this.preloadSchema(node.textValue(), schema);
    }

    public LoadingConfigurationBuilder addParserFeature(JsonParser.Feature feature) {
        BUNDLE.checkNotNull((Object)feature, "loadingCfg.nullJsonParserFeature");
        this.parserFeatures.add(feature);
        return this;
    }

    public LoadingConfigurationBuilder removeParserFeature(JsonParser.Feature feature) {
        BUNDLE.checkNotNull((Object)feature, "loadingCfg.nullJsonParserFeature");
        if (feature != JsonParser.Feature.AUTO_CLOSE_SOURCE) {
            this.parserFeatures.remove(feature);
        }
        return this;
    }

    public LoadingConfiguration freeze() {
        return new LoadingConfiguration(this);
    }

    private static String checkScheme(String scheme) {
        BUNDLE.checkNotNull((Object)scheme, "loadingCfg.nullScheme");
        BUNDLE.checkArgument(!scheme.isEmpty(), "loadingCfg.emptyScheme");
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new IllegalArgumentException(BUNDLE.printf("loadingCfg.illegalScheme", new Object[]{scheme}));
        }
        return scheme;
    }

    private static URI getLocator(String input) {
        JsonRef ref;
        try {
            ref = JsonRef.fromString(input);
        }
        catch (JsonReferenceException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "jsonRef.notAbsolute", new Object[]{ref});
        return ref.getLocator();
    }

    static {
        int i = JsonParser.Feature.collectDefaults();
        DEFAULT_PARSER_FEATURES = EnumSet.noneOf(JsonParser.Feature.class);
        for (JsonParser.Feature feature : JsonParser.Feature.values()) {
            if ((i & 1 << feature.ordinal()) == 0) continue;
            DEFAULT_PARSER_FEATURES.add(feature);
        }
    }
}

