/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.Frozen;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.load.uri.URITransformer;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;

public final class LoadingConfiguration
implements Frozen<LoadingConfigurationBuilder> {
    final Dictionary<URIDownloader> downloaders;
    final URITransformer transformer;
    final Dereferencing dereferencing;
    final Map<URI, JsonNode> preloadedSchemas;
    final EnumSet<JsonParser.Feature> parserFeatures;
    final ObjectReader objectReader;

    public static LoadingConfigurationBuilder newBuilder() {
        return new LoadingConfigurationBuilder();
    }

    public static LoadingConfiguration byDefault() {
        return new LoadingConfigurationBuilder().freeze();
    }

    LoadingConfiguration(LoadingConfigurationBuilder builder) {
        this.downloaders = builder.downloaders.freeze();
        this.transformer = builder.transformer;
        this.dereferencing = builder.dereferencing;
        this.preloadedSchemas = ImmutableMap.copyOf(builder.preloadedSchemas);
        this.parserFeatures = EnumSet.copyOf(builder.parserFeatures);
        this.objectReader = this.constructObjectReader();
    }

    private ObjectReader constructObjectReader() {
        ObjectMapper mapper = JacksonUtils.newMapper();
        for (JsonParser.Feature feature : this.parserFeatures) {
            mapper.configure(feature, true);
        }
        return mapper.reader();
    }

    public Dictionary<URIDownloader> getDownloaders() {
        return this.downloaders;
    }

    public URITransformer getTransformer() {
        return this.transformer;
    }

    public Dereferencing getDereferencing() {
        return this.dereferencing;
    }

    public Map<URI, JsonNode> getPreloadedSchemas() {
        return this.preloadedSchemas;
    }

    public ObjectReader getObjectReader() {
        return this.objectReader;
    }

    public LoadingConfigurationBuilder thaw() {
        return new LoadingConfigurationBuilder(this);
    }
}

