/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder;

import com.github.jasync.sql.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.jasync.sql.db.mysql.encoder.HandshakeResponseEncoder;
import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.encoder.auth.AuthenticationMethod;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.mysql.message.client.HandshakeResponseMessage;
import com.github.jasync.sql.db.mysql.util.CharsetMapper;
import com.github.jasync.sql.db.util.ByteBufExtensionsKt;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/HandshakeResponseEncoder;", "Lcom/github/jasync/sql/db/mysql/encoder/MessageEncoder;", "charset", "Ljava/nio/charset/Charset;", "charsetMapper", "Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;)V", "authenticationMethods", "", "", "Lcom/github/jasync/sql/db/mysql/encoder/auth/AuthenticationMethod;", "getCharset", "()Ljava/nio/charset/Charset;", "getCharsetMapper", "()Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "Companion", "jasync-mysql"})
public final class HandshakeResponseEncoder
implements MessageEncoder {
    private final Map<String, AuthenticationMethod> authenticationMethods;
    @NotNull
    private final Charset charset;
    @NotNull
    private final CharsetMapper charsetMapper;
    @NotNull
    public static final String APP_NAME_KEY = "_client_name";
    public static final int MAX_3_BYTES = 0xFFFFFF;
    @NotNull
    private static final byte[] PADDING;
    public static final Companion Companion;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Object bytes;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        HandshakeResponseMessage m = (HandshakeResponseMessage)message;
        int clientCapabilities = 0;
        clientCapabilities = clientCapabilities | 0x80000 | 0x200 | 0x2000 | 0x20000 | 0x8000;
        if (m.getDatabase() != null) {
            clientCapabilities |= 8;
        }
        if (m.getAppName() != null) {
            clientCapabilities |= 0x100000;
        }
        ByteBuf buffer = ByteBufferUtils.packetBuffer();
        buffer.writeInt(clientCapabilities);
        buffer.writeInt(0xFFFFFF);
        buffer.writeByte(this.charsetMapper.toInt(this.charset));
        buffer.writeBytes(PADDING);
        ByteBufferUtils.writeCString((String)m.getUsername(), (ByteBuf)buffer, (Charset)this.charset);
        if (m.getPassword() != null) {
            String method = m.getAuthenticationMethod();
            Map<String, AuthenticationMethod> map = this.authenticationMethods;
            AuthenticationMethod authenticationMethod = map.get(method);
            if (authenticationMethod == null) {
                boolean bl = false;
                throw (Throwable)new UnsupportedAuthenticationMethodException(method);
            }
            AuthenticationMethod authenticator = authenticationMethod;
            bytes = authenticator.generateAuthentication(this.charset, m.getPassword(), m.getSeed());
            buffer.writeByte(CollectionsUtilsKt.getLength((byte[])bytes));
            buffer.writeBytes((byte[])bytes);
        } else {
            buffer.writeByte(0);
        }
        if (m.getDatabase() != null) {
            ByteBufferUtils.writeCString((String)m.getDatabase(), (ByteBuf)buffer, (Charset)this.charset);
        }
        ByteBufferUtils.writeCString((String)m.getAuthenticationMethod(), (ByteBuf)buffer, (Charset)this.charset);
        if (m.getAppName() != null) {
            Function1 byteWidthEvaluator2 = encode.byteWidthEvaluator.1.INSTANCE;
            bytes = APP_NAME_KEY;
            Object bl = this.charset;
            byte[] byArray = ((String)bytes).getBytes((Charset)bl);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] key = byArray;
            bl = m.getAppName();
            Charset charset = this.charset;
            Object object = bl;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = ((String)object).getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] value = byArray2;
            int totalLength = CollectionsUtilsKt.getLength((byte[])key) + ((Number)byteWidthEvaluator2.invoke((Object)CollectionsUtilsKt.getLength((byte[])key))).intValue() + CollectionsUtilsKt.getLength((byte[])value) + ((Number)byteWidthEvaluator2.invoke((Object)CollectionsUtilsKt.getLength((byte[])value))).intValue();
            ByteBuf byteBuf = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
            ByteBufExtensionsKt.writeLength((ByteBuf)byteBuf, (long)totalLength);
            ByteBufExtensionsKt.writeLengthEncodedString((ByteBuf)buffer, (String)APP_NAME_KEY, (Charset)this.charset);
            ByteBufExtensionsKt.writeLengthEncodedString((ByteBuf)buffer, (String)m.getAppName(), (Charset)this.charset);
        }
        ByteBuf byteBuf = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
        return byteBuf;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @NotNull
    public final CharsetMapper getCharsetMapper() {
        return this.charsetMapper;
    }

    public HandshakeResponseEncoder(@NotNull Charset charset, @NotNull CharsetMapper charsetMapper) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Intrinsics.checkParameterIsNotNull((Object)charsetMapper, (String)"charsetMapper");
        this.charset = charset;
        this.charsetMapper = charsetMapper;
        this.authenticationMethods = AuthenticationMethod.Companion.getAvailables();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Companion = new Companion(null);
        int size$iv = 23;
        byte[] result$iv = new byte[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            byte by;
            void i$iv;
            void var4_4 = i$iv;
            void var8_7 = i$iv++;
            byte[] byArray = result$iv;
            boolean bl = false;
            byArray[var8_7] = by = (byte)0;
        }
        PADDING = var1_1;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/HandshakeResponseEncoder$Companion;", "", "()V", "APP_NAME_KEY", "", "MAX_3_BYTES", "", "PADDING", "", "getPADDING", "()[B", "jasync-mysql"})
    public static final class Companion {
        @NotNull
        public final byte[] getPADDING() {
            return PADDING;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

