/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "builder", "Lorg/joda/time/format/DateTimeFormatterBuilder;", "kotlin.jvm.PlatformType", "format", "Lorg/joda/time/format/DateTimeFormatter;", "nonTimezonedPrinter", "optional", "Lorg/joda/time/format/DateTimeParser;", "optionalTimeZone", "timezonedPrinter", "decode", "", "value", "", "encode", "formatter", "Companion", "jasync-common"})
public class TimestampEncoderDecoder
implements ColumnEncoderDecoder {
    private final DateTimeParser optional = new DateTimeFormatterBuilder().appendPattern(".SSSSSS").toParser();
    private final DateTimeParser optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("Z").toParser();
    private final DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(this.optional).appendOptional(this.optionalTimeZone);
    private final DateTimeFormatter timezonedPrinter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSSSSSZ").toFormatter();
    private final DateTimeFormatter nonTimezonedPrinter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").toFormatter();
    private final DateTimeFormatter format = this.builder.toFormatter();
    @NotNull
    public static final String BaseFormat = "yyyy-MM-dd HH:mm:ss";
    @NotNull
    public static final String MillisFormat = ".SSSSSS";
    @NotNull
    private static final TimestampEncoderDecoder Instance;
    public static final Companion Companion;

    public DateTimeFormatter formatter() {
        return this.format;
    }

    @Override
    @NotNull
    public Object decode(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        LocalDateTime localDateTime = this.formatter().parseLocalDateTime(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"formatter().parseLocalDateTime(value)");
        return localDateTime;
    }

    @Override
    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            String string2 = this.timezonedPrinter.print((ReadableInstant)new DateTime(value));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.timezonedPrinter.print(DateTime(value))");
        } else if (object instanceof Date) {
            String string3 = this.timezonedPrinter.print((ReadableInstant)new DateTime(value));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"this.timezonedPrinter.print(DateTime(value))");
        } else if (object instanceof Calendar) {
            String string4 = this.timezonedPrinter.print((ReadableInstant)new DateTime(value));
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"this.timezonedPrinter.print(DateTime(value))");
        } else if (object instanceof LocalDateTime) {
            String string5 = this.nonTimezonedPrinter.print((ReadablePartial)value);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"this.nonTimezonedPrinter.print(value)");
        } else if (object instanceof ReadableDateTime) {
            String string6 = this.timezonedPrinter.print((ReadableInstant)value);
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"this.timezonedPrinter.print(value)");
        } else {
            throw (Throwable)new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        Instance = new TimestampEncoderDecoder();
    }

    @Override
    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder$Companion;", "", "()V", "BaseFormat", "", "Instance", "Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder;", "getInstance", "()Lcom/github/jasync/sql/db/column/TimestampEncoderDecoder;", "MillisFormat", "jasync-common"})
    public static final class Companion {
        @NotNull
        public final TimestampEncoderDecoder getInstance() {
            return Instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

