/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.net.util.IPAddressUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/jasync/sql/db/column/InetAddressEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "decode", "", "value", "", "encode", "jasync-common"})
public final class InetAddressEncoderDecoder
implements ColumnEncoderDecoder {
    public static final InetAddressEncoderDecoder INSTANCE;

    @Override
    @NotNull
    public Object decode(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        InetAddress inetAddress = StringsKt.contains$default((CharSequence)value, (char)':', (boolean)false, (int)2, null) ? InetAddress.getByAddress(IPAddressUtil.textToNumericFormatV6(value)) : InetAddress.getByAddress(IPAddressUtil.textToNumericFormatV4(value));
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"if (value.contains(':'))\u2026ormatV4(value))\n        }");
        return inetAddress;
    }

    @Override
    @NotNull
    public String encode(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = ((InetAddress)value).getHostAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(value as InetAddress).hostAddress");
        return string;
    }

    private InetAddressEncoderDecoder() {
    }

    static {
        InetAddressEncoderDecoder inetAddressEncoderDecoder;
        INSTANCE = inetAddressEncoderDecoder = new InetAddressEncoderDecoder();
    }

    @Override
    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding(this);
    }
}

