/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.pool;

import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.pool.ActorBasedObjectPool;
import com.github.jasync.sql.db.pool.AsyncObjectPool;
import com.github.jasync.sql.db.pool.ObjectFactory;
import com.github.jasync.sql.db.pool.PoolConfiguration;
import com.github.jasync.sql.db.pool.PooledObject;
import com.github.jasync.sql.db.util.ExecutorServiceUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0002B'\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J!\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00162\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ.\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0016\"\u0004\b\u0001\u0010\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00160\u001fH\u0016J\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\b\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u0014J&\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00162\u0006\u0010&\u001a\u00020\u000e2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u0014H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u00162\u0006\u0010&\u001a\u00020\u000eH\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/github/jasync/sql/db/pool/ConnectionPool;", "T", "Lcom/github/jasync/sql/db/Connection;", "Lcom/github/jasync/sql/db/pool/AsyncObjectPool;", "factory", "Lcom/github/jasync/sql/db/pool/ObjectFactory;", "configuration", "Lcom/github/jasync/sql/db/pool/PoolConfiguration;", "executionContext", "Ljava/util/concurrent/Executor;", "(Lcom/github/jasync/sql/db/pool/ObjectFactory;Lcom/github/jasync/sql/db/pool/PoolConfiguration;Ljava/util/concurrent/Executor;)V", "getConfiguration", "()Lcom/github/jasync/sql/db/pool/PoolConfiguration;", "id", "", "getId", "()Ljava/lang/String;", "objectPool", "Lcom/github/jasync/sql/db/pool/ActorBasedObjectPool;", "availables", "", "close", "Ljava/util/concurrent/CompletableFuture;", "connect", "disconnect", "giveBack", "item", "(Lcom/github/jasync/sql/db/Connection;)Ljava/util/concurrent/CompletableFuture;", "inTransaction", "A", "f", "Lkotlin/Function1;", "inUse", "isConnected", "", "queued", "sendPreparedStatement", "Lcom/github/jasync/sql/db/QueryResult;", "query", "values", "", "sendQuery", "take", "jasync-common"})
public final class ConnectionPool<T extends Connection>
implements AsyncObjectPool<T>,
Connection {
    private final ActorBasedObjectPool<T> objectPool;
    @NotNull
    private final PoolConfiguration configuration;
    private final Executor executionContext;

    @Override
    @NotNull
    public String getId() {
        String reason$iv = "not implemented as it is not a real connection";
        throw (Throwable)new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<Connection> disconnect() {
        CompletionStage<Connection> completionStage;
        if (this.isConnected()) {
            void $receiver$iv;
            CompletableFuture<AsyncObjectPool<T>> completableFuture = this.objectPool.close();
            Executor executor$iv = this.executionContext;
            CompletionStage completionStage2 = $receiver$iv.thenApplyAsync(new Function<AsyncObjectPool<T>, Connection>(this){
                final /* synthetic */ ConnectionPool this$0;
                {
                    this.this$0 = connectionPool;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object apply(Object it) {
                    AsyncObjectPool item = (AsyncObjectPool)it;
                    return this.this$0;
                }
            }, executor$iv);
            completionStage = completionStage2;
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage2, (String)"thenApplyAsync(Function { f(it) }, executor)");
        } else {
            CompletableFuture<Connection> completableFuture = CompletableFuture.completedFuture(this);
            completionStage = completableFuture;
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(this)");
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<Connection> connect() {
        CompletableFuture<Connection> completableFuture = CompletableFuture.completedFuture(this);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(this)");
        return completableFuture;
    }

    @Override
    public boolean isConnected() {
        return !this.objectPool.getClosed();
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendQuery(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return this.objectPool.use(this.executionContext, (Function1)new Function1<T, CompletableFuture<QueryResult>>(query){
            final /* synthetic */ String $query;

            @NotNull
            public final CompletableFuture<QueryResult> invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return it.sendQuery(this.$query);
            }
            {
                this.$query = string;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query, @NotNull List<? extends Object> values) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return this.objectPool.use(this.executionContext, (Function1)new Function1<T, CompletableFuture<QueryResult>>(query, values){
            final /* synthetic */ String $query;
            final /* synthetic */ List $values;

            @NotNull
            public final CompletableFuture<QueryResult> invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return it.sendPreparedStatement(this.$query, this.$values);
            }
            {
                this.$query = string;
                this.$values = list;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public <A> CompletableFuture<A> inTransaction(@NotNull Function1<? super Connection, ? extends CompletableFuture<A>> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.objectPool.use(this.executionContext, (Function1)new Function1<T, CompletableFuture<A>>(f){
            final /* synthetic */ Function1 $f;

            @NotNull
            public final CompletableFuture<A> invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return it.inTransaction(this.$f);
            }
            {
                this.$f = function1;
                super(1);
            }
        });
    }

    @NotNull
    public final List<T> availables() {
        return this.objectPool.getAvailableItems();
    }

    @NotNull
    public final List<CompletableFuture<T>> queued() {
        return this.objectPool.getWaitingForItem();
    }

    @NotNull
    public final List<T> inUse() {
        return this.objectPool.getUsedItems();
    }

    @Override
    @NotNull
    public CompletableFuture<T> take() {
        return this.objectPool.take();
    }

    @Override
    @NotNull
    public CompletableFuture<AsyncObjectPool<T>> giveBack(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        return this.objectPool.giveBack((PooledObject)item);
    }

    @Override
    @NotNull
    public CompletableFuture<AsyncObjectPool<T>> close() {
        return this.objectPool.close();
    }

    @NotNull
    public final PoolConfiguration getConfiguration() {
        return this.configuration;
    }

    @JvmOverloads
    public ConnectionPool(@NotNull ObjectFactory<T> factory, @NotNull PoolConfiguration configuration, @NotNull Executor executionContext) {
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
        this.configuration = configuration;
        this.executionContext = executionContext;
        this.objectPool = new ActorBasedObjectPool<T>(factory, this.configuration);
    }

    @JvmOverloads
    public /* synthetic */ ConnectionPool(ObjectFactory objectFactory, PoolConfiguration poolConfiguration, Executor executor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            executor2 = ExecutorServiceUtils.INSTANCE.getCommonPool();
        }
        this(objectFactory, poolConfiguration, executor2);
    }

    @JvmOverloads
    public ConnectionPool(@NotNull ObjectFactory<T> factory, @NotNull PoolConfiguration configuration) {
        this(factory, configuration, null, 4, null);
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return Connection.DefaultImpls.sendPreparedStatement(this, query);
    }

    @Override
    @NotNull
    public <A> CompletableFuture<A> use(@NotNull Executor executor2, @NotNull Function1<? super T, ? extends CompletableFuture<A>> function) {
        Intrinsics.checkParameterIsNotNull((Object)executor2, (String)"executor");
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return AsyncObjectPool.DefaultImpls.use(this, executor2, function);
    }
}

