/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.github.jasminb.jsonapi.ReflectionUtils;
import com.github.jasminb.jsonapi.annotations.Id;
import com.github.jasminb.jsonapi.annotations.Links;
import com.github.jasminb.jsonapi.annotations.Meta;
import com.github.jasminb.jsonapi.annotations.Relationship;
import com.github.jasminb.jsonapi.annotations.Type;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterConfiguration {
    private final Map<String, Class<?>> typeToClassMapping = new HashMap();
    private final Map<Class<?>, Type> typeAnnotations = new HashMap();
    private final Map<Class<?>, Field> idMap = new HashMap();
    private final Map<Class<?>, List<Field>> relationshipMap = new HashMap();
    private final Map<Class<?>, Map<String, Class<?>>> relationshipTypeMap = new HashMap();
    private final Map<Class<?>, Map<String, Field>> relationshipFieldMap = new HashMap();
    private final Map<Field, Relationship> fieldRelationshipMap = new HashMap<Field, Relationship>();
    private final Map<Class<?>, Class<?>> metaTypeMap = new HashMap();
    private final Map<Class<?>, Field> metaFieldMap = new HashMap();
    private final Map<Class<?>, Field> linkFieldMap = new HashMap();

    public ConverterConfiguration(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.processClass(clazz);
        }
    }

    private void processClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Type.class)) {
            Type annotation = clazz.getAnnotation(Type.class);
            this.typeToClassMapping.put(annotation.value(), clazz);
            this.typeAnnotations.put(clazz, annotation);
            this.relationshipTypeMap.put(clazz, new HashMap());
            this.relationshipFieldMap.put(clazz, new HashMap());
            List<Field> relationshipFields = ReflectionUtils.getAnnotatedFields(clazz, Relationship.class, true);
            for (Field relationshipField : relationshipFields) {
                relationshipField.setAccessible(true);
                Relationship relationship = relationshipField.getAnnotation(Relationship.class);
                Class<?> targetType = ReflectionUtils.getFieldType(relationshipField);
                this.relationshipTypeMap.get(clazz).put(relationship.value(), targetType);
                this.relationshipFieldMap.get(clazz).put(relationship.value(), relationshipField);
                this.fieldRelationshipMap.put(relationshipField, relationship);
                if (!relationship.resolve() || relationship.relType() != null) continue;
                throw new IllegalArgumentException("@Relationship on " + clazz.getName() + "#" + relationshipField.getName() + " with 'resolve = true' must have a relType attribute " + "set.");
            }
            this.relationshipMap.put(clazz, relationshipFields);
            List<Field> idAnnotatedFields = ReflectionUtils.getAnnotatedFields(clazz, Id.class, true);
            if (idAnnotatedFields.isEmpty() || idAnnotatedFields.size() != 1) {
                if (idAnnotatedFields.isEmpty()) {
                    throw new IllegalArgumentException("All resource classes must have a field annotated with the @Id annotation");
                }
                throw new IllegalArgumentException("Only single @Id annotation is allowed per defined type!");
            }
            Field idField = idAnnotatedFields.get(0);
            idField.setAccessible(true);
            this.idMap.put(clazz, idField);
            List<Field> metaFields = ReflectionUtils.getAnnotatedFields(clazz, Meta.class, true);
            if (metaFields.size() == 1) {
                Field metaField = metaFields.get(0);
                metaField.setAccessible(true);
                Class<?> metaType = ReflectionUtils.getFieldType(metaField);
                this.metaTypeMap.put(clazz, metaType);
                this.metaFieldMap.put(clazz, metaField);
            } else if (metaFields.size() > 1) {
                throw new IllegalArgumentException(String.format("Only one meta field is allowed for type '%s'", clazz.getCanonicalName()));
            }
            List<Field> linkFields = ReflectionUtils.getAnnotatedFields(clazz, Links.class, true);
            if (linkFields.size() == 1) {
                Field linkField = linkFields.get(0);
                linkField.setAccessible(true);
                Class<?> metaType = ReflectionUtils.getFieldType(linkField);
                if (!com.github.jasminb.jsonapi.Links.class.isAssignableFrom(metaType)) {
                    throw new IllegalArgumentException(String.format("%s is not allowed to be used as @Links attribute. Only com.github.jasminb.jsonapi.Links or its derivatives can be annotated as @Links", metaType.getCanonicalName()));
                }
                this.linkFieldMap.put(clazz, linkField);
            } else if (linkFields.size() > 1) {
                throw new IllegalArgumentException(String.format("Only one links field is allowed for type '%s'", clazz.getCanonicalName()));
            }
        } else {
            throw new IllegalArgumentException("All resource classes must be annotated with Type annotation!");
        }
    }

    public Field getMetaField(Class<?> clazz) {
        return this.metaFieldMap.get(clazz);
    }

    public Class<?> getMetaType(Class<?> clazz) {
        return this.metaTypeMap.get(clazz);
    }

    public Field getLinksField(Class<?> clazz) {
        return this.linkFieldMap.get(clazz);
    }

    public Class<?> getTypeClass(String typeName) {
        return this.typeToClassMapping.get(typeName);
    }

    public Field getIdField(Class<?> clazz) {
        return this.idMap.get(clazz);
    }

    public Field getRelationshipField(Class<?> clazz, String fieldName) {
        return this.relationshipFieldMap.get(clazz).get(fieldName);
    }

    public Class<?> getRelationshipType(Class<?> clazz, String fieldName) {
        return this.relationshipTypeMap.get(clazz).get(fieldName);
    }

    public Relationship getFieldRelationship(Field field) {
        return this.fieldRelationshipMap.get(field);
    }

    public List<Field> getRelationshipFields(Class<?> clazz) {
        return this.relationshipMap.get(clazz);
    }

    public boolean isRegisteredType(Class<?> clazz) {
        return this.typeAnnotations.containsKey(clazz);
    }

    public String getTypeName(Class<?> clazz) {
        Type type = this.typeAnnotations.get(clazz);
        if (type != null) {
            return type.value();
        }
        return null;
    }
}

