/*
 * Decompiled with CFR 0.152.
 */
package com.alexzh.circleimageview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.alexzh.circleimageview.ItemSelectedListener;
import com.alexzh.circleimageview.R;
import com.alexzh.circleimageview.utils.MathUtils;
import com.nineoldandroids.animation.ObjectAnimator;

public class CircleImageView
extends ImageView {
    private static final int DEFAULT_SHADOW_COLOR = -16777216;
    private static final int DEFAULT_BORDER_COLOR = -1;
    private static final int DEFAULT_BORDER_SELECTED_COLOR = -65536;
    private static final float DEFAULT_SHADOW_RADIUS = 0.0f;
    private static final float DEFAULT_SHADOW_DX = 0.0f;
    private static final float DEFAULT_SHADOW_DY = 0.0f;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final float DEFAULT_PRESSED_RING_WIDTH = 0.0f;
    private static final int DEFAULT_PRESSED_RING_COLOR = -16711681;
    private static final int ANIMATION_TIME = 0x10E0000;
    private static final String ANIMATION_PROGRESS_ATTR = "animationProgress";
    private int mBorderWidth;
    private int mCanvasSize;
    private float mShadowRadius;
    private int mShadowColor;
    private float mShadowDx;
    private float mShadowDy;
    private Bitmap mImageBitmap;
    private Drawable mDrawable;
    private Paint mPaintImage;
    private Paint mPaintBorder;
    private Paint mPaintBackground;
    private int mBorderColor;
    private int mBorderSelectedColor;
    private int mCenterX;
    private int mCenterY;
    private int mRadius;
    private ItemSelectedListener mListener;
    private boolean mIsSelectedState;
    private int mBackgroundColor;
    private float mAnimationProgress;
    private ObjectAnimator mPressedAnimator;
    private int mPressedRingColor;
    private int mPressedRingWidth;
    private int mCurrentPressedRingWidth;

    public CircleImageView(Context context) {
        this(context, null, R.styleable.CircleImageViewStyle_circleImageViewDefault);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.styleable.CircleImageViewStyle_circleImageViewDefault);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyleAttr, 0);
        this.mBackgroundColor = attributes.getColor(R.styleable.CircleImageView_view_backgroundColor, context.getResources().getColor(17170445));
        this.mBorderColor = attributes.getColor(R.styleable.CircleImageView_view_borderColor, -1);
        this.mBorderWidth = attributes.getDimensionPixelOffset(R.styleable.CircleImageView_view_borderWidth, 0);
        this.mBorderSelectedColor = attributes.getColor(R.styleable.CircleImageView_view_selectedColor, -65536);
        this.mShadowRadius = attributes.getDimension(R.styleable.CircleImageView_view_shadowRadius, 0.0f);
        this.mShadowColor = attributes.getColor(R.styleable.CircleImageView_view_shadowColor, -16777216);
        this.mShadowDx = attributes.getDimension(R.styleable.CircleImageView_view_shadowDx, 0.0f);
        this.mShadowDy = attributes.getDimension(R.styleable.CircleImageView_view_shadowDy, 0.0f);
        this.mPressedRingWidth = (int)attributes.getDimension(R.styleable.CircleImageView_view_pressedRingWidth, 0.0f);
        this.mPressedRingColor = attributes.getColor(R.styleable.CircleImageView_view_pressedRingColor, -16711681);
        attributes.recycle();
        this.mPressedAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)ANIMATION_PROGRESS_ATTR, (float[])new float[]{0.0f, 0.0f});
        this.mPressedAnimator.setDuration((long)this.getResources().getInteger(0x10E0000));
        this.mPaintImage = new Paint(1);
        this.mPaintBorder = new Paint(1);
        this.mPaintBackground = new Paint(1);
        this.setBackgroundColor(this.mBackgroundColor);
        this.setBorderColor(this.mBorderColor);
        this.setBorderWidth(this.mBorderWidth);
        this.drawShadow(this.mShadowRadius, this.mShadowColor, this.mShadowDx, this.mShadowDy);
    }

    public void setOnItemSelectedClickListener(ItemSelectedListener listener) {
        this.mListener = listener;
    }

    public void setBorderWidth(int borderWidth) {
        if (this.mBackgroundColor != borderWidth) {
            this.mBorderWidth = borderWidth;
        }
        this.requestLayout();
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        if (this.mPaintBorder != null) {
            this.mPaintBorder.setColor(borderColor);
        }
        this.invalidate();
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.mPaintBackground != null) {
            this.mPaintBackground.setColor(backgroundColor);
        }
        this.invalidate();
    }

    public void addShadow() {
        if (this.mShadowRadius == 0.0f) {
            this.mShadowRadius = 0.0f;
        }
        this.drawShadow(this.mShadowRadius, this.mShadowColor, this.mShadowDx, this.mShadowDy);
        this.invalidate();
    }

    public void setShadowRadius(float shadowRadius) {
        this.drawShadow(shadowRadius, this.mShadowColor, this.mShadowDx, this.mShadowDy);
        this.invalidate();
    }

    public void setShadowColor(int shadowColor) {
        this.drawShadow(this.mShadowRadius, shadowColor, this.mShadowDx, this.mShadowDy);
        this.invalidate();
    }

    public void setShadowDx(float shadowDx) {
        this.drawShadow(this.mShadowRadius, this.mShadowColor, shadowDx, this.mShadowDy);
        this.invalidate();
    }

    public void setShadowDy(float shadowDy) {
        this.drawShadow(this.mShadowRadius, this.mShadowColor, this.mShadowDx, shadowDy);
        this.invalidate();
    }

    public void onDraw(Canvas canvas) {
        this.initImage();
        if (this.mImageBitmap == null) {
            return;
        }
        this.calculateCircleData(canvas);
        canvas.drawCircle((float)(this.mCenterX + this.mBorderWidth), (float)(this.mCenterY + this.mBorderWidth), (float)(this.mRadius + this.mBorderWidth) - (this.mShadowRadius + this.mShadowRadius / 2.0f) + this.mAnimationProgress, this.mPaintBorder);
        canvas.drawCircle((float)(this.mCenterX + this.mBorderWidth), (float)(this.mCenterY + this.mBorderWidth), (float)this.mRadius - (this.mShadowRadius + this.mShadowRadius / 2.0f), this.mPaintBackground);
        canvas.drawCircle((float)(this.mCenterX + this.mBorderWidth), (float)(this.mCenterY + this.mBorderWidth), (float)this.mRadius - (this.mShadowRadius + this.mShadowRadius / 2.0f), this.mPaintImage);
    }

    private void calculateCircleData(Canvas canvas) {
        if (this.mRadius != 0) {
            return;
        }
        if (!this.isInEditMode()) {
            this.mCanvasSize = canvas.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - MathUtils.twiceValue(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth));
            if (canvas.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - MathUtils.twiceValue(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth)) < this.mCanvasSize) {
                this.mCanvasSize = canvas.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - MathUtils.twiceValue(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth));
            }
        }
        this.mRadius = (this.mCanvasSize - MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth) * 2) / 2;
        this.mCenterX = this.getPaddingLeft() + this.mRadius + Math.abs(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth));
        this.mCenterY = this.getPaddingTop() + this.mRadius + Math.abs(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth));
        this.updateShader();
    }

    private void initImage() {
        if (this.mDrawable == this.getDrawable()) {
            return;
        }
        this.mDrawable = this.getDrawable();
        this.mImageBitmap = this.drawableToBitmap(this.mDrawable);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCanvasSize = w;
        this.mRadius = 0;
        if (h < this.mCanvasSize) {
            this.mCanvasSize = h;
        }
        if (this.mImageBitmap != null) {
            this.updateShader();
        }
    }

    private void drawShadow(float shadowRadius, int shadowColor, float shadowDx, float shadowDy) {
        if (this.mShadowRadius != shadowRadius) {
            this.mShadowRadius = shadowRadius;
        }
        if (this.mShadowColor != shadowColor) {
            this.mShadowColor = shadowColor;
        }
        if (this.mShadowDx != shadowDx) {
            this.mShadowDx = shadowDx;
        }
        if (this.mShadowDy != shadowDy) {
            this.mShadowDy = shadowDy;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.mPaintBorder);
        }
        this.mPaintBorder.setShadowLayer(shadowRadius, shadowDx, shadowDy, shadowColor);
    }

    private void updateShader() {
        if (this.mImageBitmap == null) {
            return;
        }
        Matrix matrix = new Matrix();
        this.mImageBitmap = this.cropBitmap(this.mImageBitmap);
        BitmapShader shader = new BitmapShader(this.mImageBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        RectF bitmapRect = new RectF(0.0f, 0.0f, (float)this.mImageBitmap.getWidth(), (float)this.mImageBitmap.getHeight());
        RectF viewRect = new RectF(0.0f, 0.0f, (float)(this.mCanvasSize - MathUtils.twiceValue(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth))), (float)(this.mCanvasSize - MathUtils.twiceValue(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth))));
        matrix.setRectToRect(bitmapRect, viewRect, Matrix.ScaleToFit.CENTER);
        matrix.postTranslate((float)(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth) + this.getPaddingLeft()), (float)(MathUtils.getBorderMax(this.mPressedRingWidth, this.mBorderWidth) + this.getPaddingTop()));
        shader.setLocalMatrix(matrix);
        this.mPaintImage.setShader((Shader)shader);
    }

    private Bitmap cropBitmap(Bitmap bitmap) {
        Bitmap bmp = bitmap.getWidth() >= bitmap.getHeight() ? Bitmap.createBitmap((Bitmap)bitmap, (int)(bitmap.getWidth() / 2 - bitmap.getHeight() / 2), (int)0, (int)bitmap.getHeight(), (int)bitmap.getHeight()) : Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(bitmap.getHeight() / 2 - bitmap.getWidth() / 2), (int)bitmap.getWidth(), (int)bitmap.getWidth());
        return bmp;
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        int intrinsicHeight = drawable.getIntrinsicHeight();
        if (intrinsicWidth <= 0 || intrinsicHeight <= 0) {
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)intrinsicWidth, (int)intrinsicHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)((Object)((Object)this)).getClass().toString(), (String)"Encountered OutOfMemoryError while generating bitmap!");
            return null;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = this.measureWidth(widthMeasureSpec);
        int imageSize = width < (height = this.measureHeight(heightMeasureSpec)) ? width : height;
        this.setMeasuredDimension(imageSize, imageSize);
    }

    private int measureWidth(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.mCanvasSize);
        return result;
    }

    private int measureHeight(int measureSpecHeight) {
        int specMode = View.MeasureSpec.getMode((int)measureSpecHeight);
        int specSize = View.MeasureSpec.getSize((int)measureSpecHeight);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? specSize : this.mCanvasSize);
        return result + 2;
    }

    private float getAnimationProgress() {
        return this.mAnimationProgress;
    }

    private void setAnimationProgress(float progress) {
        this.mAnimationProgress = progress;
        this.invalidate();
    }

    private void showPressedRing() {
        this.mCurrentPressedRingWidth = 0;
        this.mPressedAnimator.setFloatValues(new float[]{this.mAnimationProgress, this.mPressedRingWidth});
        this.mPressedAnimator.start();
        this.mIsSelectedState = !this.mIsSelectedState;
    }

    private void hidePressedRing(int currentPressedRingWidth) {
        this.mPressedAnimator.setFloatValues(new float[]{currentPressedRingWidth, 0.0f});
        this.mPressedAnimator.start();
        if (this.mListener != null) {
            if (this.mIsSelectedState) {
                this.mListener.onSelected((View)this);
            } else {
                this.mListener.onUnselected((View)this);
            }
        }
    }
}

