/*
 * Decompiled with CFR 0.152.
 */
package at.grabner.circleprogress;

import android.animation.TimeInterpolator;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import at.grabner.circleprogress.AnimationMsg;
import at.grabner.circleprogress.AnimationState;
import at.grabner.circleprogress.CircleProgressView;
import java.lang.ref.WeakReference;

public class AnimationHandler
extends Handler {
    private final WeakReference<CircleProgressView> mCircleViewWeakReference;
    private float mSpinningBarLengthStart;
    private long mAnimationStartTime;
    private long mLengthChangeAnimationStartTime;
    private TimeInterpolator mLengthChangeInterpolator = new DecelerateInterpolator();
    private TimeInterpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private double mLengthChangeAnimationDuration;
    private long mFrameStartTime = 0L;

    AnimationHandler(CircleProgressView circleView) {
        super(circleView.getContext().getMainLooper());
        this.mCircleViewWeakReference = new WeakReference<CircleProgressView>(circleView);
    }

    public void setValueInterpolator(TimeInterpolator mInterpolator) {
        this.mInterpolator = mInterpolator;
    }

    public void setLengthChangeInterpolator(TimeInterpolator mLengthChangeInterpolator) {
        this.mLengthChangeInterpolator = mLengthChangeInterpolator;
    }

    public void handleMessage(Message msg) {
        CircleProgressView circleView = (CircleProgressView)((Object)this.mCircleViewWeakReference.get());
        if (circleView == null) {
            return;
        }
        int msgType = AnimationMsg.values$47292116()[msg.what];
        if (msgType == AnimationMsg.TICK$48cb079c) {
            this.removeMessages(AnimationMsg.TICK$48cb079c - 1);
        }
        this.mFrameStartTime = SystemClock.uptimeMillis();
        switch (circleView.mAnimationState) {
            case IDLE: {
                switch (1.$SwitchMap$at$grabner$circleprogress$AnimationMsg[msgType - 1]) {
                    case 1: {
                        this.enterSpinning(circleView);
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        AnimationHandler.setValue(msg, circleView);
                        return;
                    }
                    case 4: {
                        CircleProgressView circleProgressView = circleView;
                        Message message = msg;
                        AnimationHandler animationHandler = this;
                        circleProgressView.mValueFrom = ((float[])message.obj)[0];
                        circleProgressView.mValueTo = ((float[])message.obj)[1];
                        animationHandler.mAnimationStartTime = System.currentTimeMillis();
                        circleProgressView.mAnimationState = AnimationState.ANIMATING;
                        if (circleProgressView.mAnimationStateChangedListener != null) {
                            circleProgressView.mAnimationStateChangedListener.onAnimationStateChanged(circleProgressView.mAnimationState);
                        }
                        animationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleProgressView.mFrameDelayMillis - (SystemClock.uptimeMillis() - animationHandler.mFrameStartTime));
                        return;
                    }
                    case 5: {
                        this.removeMessages(AnimationMsg.TICK$48cb079c - 1);
                    }
                }
                return;
            }
            case SPINNING: {
                switch (1.$SwitchMap$at$grabner$circleprogress$AnimationMsg[msgType - 1]) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        CircleProgressView circleProgressView = circleView;
                        AnimationHandler animationHandler = this;
                        circleProgressView.mAnimationState = AnimationState.END_SPINNING;
                        animationHandler.initReduceAnimation(circleProgressView);
                        if (circleProgressView.mAnimationStateChangedListener != null) {
                            circleProgressView.mAnimationStateChangedListener.onAnimationStateChanged(circleProgressView.mAnimationState);
                        }
                        animationHandler.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleProgressView.mFrameDelayMillis - (SystemClock.uptimeMillis() - animationHandler.mFrameStartTime));
                        return;
                    }
                    case 3: {
                        AnimationHandler.setValue(msg, circleView);
                        return;
                    }
                    case 4: {
                        this.enterEndSpinningStartAnimating(circleView, msg);
                        return;
                    }
                    case 5: {
                        float f;
                        float length_delta = circleView.mSpinningBarLengthCurrent - circleView.mSpinningBarLengthOrig;
                        float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                        t = f > 1.0f ? 1.0f : t;
                        float interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                        circleView.mSpinningBarLengthCurrent = Math.abs(length_delta) < 1.0f ? circleView.mSpinningBarLengthOrig : (circleView.mSpinningBarLengthCurrent < circleView.mSpinningBarLengthOrig ? this.mSpinningBarLengthStart + (circleView.mSpinningBarLengthOrig - this.mSpinningBarLengthStart) * interpolatedRatio : this.mSpinningBarLengthStart - (this.mSpinningBarLengthStart - circleView.mSpinningBarLengthOrig) * interpolatedRatio);
                        circleView.mCurrentSpinnerDegreeValue += circleView.mSpinSpeed;
                        if (circleView.mCurrentSpinnerDegreeValue > 360.0f) {
                            circleView.mCurrentSpinnerDegreeValue = 0.0f;
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        circleView.invalidate();
                    }
                }
                return;
            }
            case END_SPINNING: {
                switch (1.$SwitchMap$at$grabner$circleprogress$AnimationMsg[msgType - 1]) {
                    case 1: {
                        circleView.mAnimationState = AnimationState.SPINNING;
                        if (circleView.mAnimationStateChangedListener != null) {
                            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        AnimationHandler.setValue(msg, circleView);
                        return;
                    }
                    case 4: {
                        this.enterEndSpinningStartAnimating(circleView, msg);
                        return;
                    }
                    case 5: {
                        float f;
                        float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                        t = f > 1.0f ? 1.0f : t;
                        float interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                        circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                        circleView.mCurrentSpinnerDegreeValue += circleView.mSpinSpeed;
                        if (circleView.mSpinningBarLengthCurrent < 0.01f) {
                            circleView.mAnimationState = AnimationState.IDLE;
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                            }
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        circleView.invalidate();
                    }
                }
                return;
            }
            case END_SPINNING_START_ANIMATING: {
                switch (1.$SwitchMap$at$grabner$circleprogress$AnimationMsg[msgType - 1]) {
                    case 1: {
                        circleView.mDrawBarWhileSpinning = false;
                        this.enterSpinning(circleView);
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        circleView.mDrawBarWhileSpinning = false;
                        AnimationHandler.setValue(msg, circleView);
                        return;
                    }
                    case 4: {
                        circleView.mValueFrom = 0.0f;
                        circleView.mValueTo = ((float[])msg.obj)[1];
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        return;
                    }
                    case 5: {
                        float interpolatedRatio;
                        float t;
                        if (circleView.mSpinningBarLengthCurrent > circleView.mSpinningBarLengthOrig && !circleView.mDrawBarWhileSpinning) {
                            float f;
                            t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                            t = f > 1.0f ? 1.0f : t;
                            interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                            circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                        }
                        circleView.mCurrentSpinnerDegreeValue += circleView.mSpinSpeed;
                        if (circleView.mCurrentSpinnerDegreeValue > 360.0f && !circleView.mDrawBarWhileSpinning) {
                            this.mAnimationStartTime = System.currentTimeMillis();
                            circleView.mDrawBarWhileSpinning = true;
                            this.initReduceAnimation(circleView);
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(AnimationState.START_ANIMATING_AFTER_SPINNING);
                            }
                        }
                        if (circleView.mDrawBarWhileSpinning) {
                            float f;
                            circleView.mCurrentSpinnerDegreeValue = 360.0f;
                            circleView.mSpinningBarLengthCurrent -= circleView.mSpinSpeed;
                            this.calcNextAnimationValue(circleView);
                            t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                            t = f > 1.0f ? 1.0f : t;
                            interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                            circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                        }
                        if ((double)circleView.mSpinningBarLengthCurrent < 0.1) {
                            circleView.mAnimationState = AnimationState.ANIMATING;
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                            }
                            circleView.invalidate();
                            circleView.mDrawBarWhileSpinning = false;
                            circleView.mSpinningBarLengthCurrent = circleView.mSpinningBarLengthOrig;
                        } else {
                            circleView.invalidate();
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                    }
                }
                return;
            }
            case ANIMATING: {
                switch (1.$SwitchMap$at$grabner$circleprogress$AnimationMsg[msgType - 1]) {
                    case 1: {
                        this.enterSpinning(circleView);
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        AnimationHandler.setValue(msg, circleView);
                        return;
                    }
                    case 4: {
                        this.mAnimationStartTime = System.currentTimeMillis();
                        circleView.mValueFrom = circleView.mCurrentValue;
                        circleView.mValueTo = ((float[])msg.obj)[1];
                        return;
                    }
                    case 5: {
                        if (this.calcNextAnimationValue(circleView)) {
                            circleView.mAnimationState = AnimationState.IDLE;
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                            }
                            circleView.mCurrentValue = circleView.mValueTo;
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        circleView.invalidate();
                    }
                }
            }
        }
    }

    private void enterEndSpinningStartAnimating(CircleProgressView circleView, Message msg) {
        circleView.mAnimationState = AnimationState.END_SPINNING_START_ANIMATING;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        circleView.mValueFrom = 0.0f;
        circleView.mValueTo = ((float[])msg.obj)[1];
        this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
        this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
    }

    private void initReduceAnimation(CircleProgressView circleView) {
        float stepsTillFinish = circleView.mSpinningBarLengthCurrent / circleView.mSpinSpeed;
        this.mLengthChangeAnimationDuration = stepsTillFinish * (float)circleView.mFrameDelayMillis * 2.0f;
        this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
        this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
    }

    private void enterSpinning(CircleProgressView circleView) {
        circleView.mAnimationState = AnimationState.SPINNING;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        circleView.mSpinningBarLengthCurrent = 360.0f / circleView.mMaxValue * circleView.mCurrentValue;
        circleView.mCurrentSpinnerDegreeValue = 360.0f / circleView.mMaxValue * circleView.mCurrentValue;
        this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
        this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
        float stepsTillFinish = circleView.mSpinningBarLengthOrig / circleView.mSpinSpeed;
        this.mLengthChangeAnimationDuration = stepsTillFinish * (float)circleView.mFrameDelayMillis * 2.0f;
        this.sendEmptyMessageDelayed(AnimationMsg.TICK$48cb079c - 1, (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
    }

    private boolean calcNextAnimationValue(CircleProgressView circleView) {
        float f;
        float t = (float)((double)(System.currentTimeMillis() - this.mAnimationStartTime) / circleView.mAnimationDuration);
        t = f > 1.0f ? 1.0f : t;
        float interpolatedRatio = this.mInterpolator.getInterpolation(t);
        circleView.mCurrentValue = circleView.mValueFrom + (circleView.mValueTo - circleView.mValueFrom) * interpolatedRatio;
        return t >= 1.0f;
    }

    private static void setValue(Message msg, CircleProgressView circleView) {
        circleView.mValueFrom = circleView.mValueTo;
        circleView.mCurrentValue = circleView.mValueTo = ((float[])msg.obj)[0];
        circleView.mAnimationState = AnimationState.IDLE;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        circleView.invalidate();
    }
}

