/*
 * Decompiled with CFR 0.152.
 */
package at.grabner.circleprogress;

import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import at.grabner.circleprogress.AnimationHandler;
import at.grabner.circleprogress.AnimationMsg;
import at.grabner.circleprogress.AnimationState;
import at.grabner.circleprogress.AnimationStateChangedListener;
import at.grabner.circleprogress.BarStartEndLine;
import at.grabner.circleprogress.ColorUtils;
import at.grabner.circleprogress.Direction;
import at.grabner.circleprogress.R;
import at.grabner.circleprogress.StrokeCap;
import at.grabner.circleprogress.TextMode;
import at.grabner.circleprogress.UnitPosition;
import java.text.DecimalFormat;

public class CircleProgressView
extends View {
    private static final String TAG = "CircleView";
    private static final boolean DEBUG = false;
    private final int mBarColorStandard = -16738680;
    protected int mLayoutHeight = 0;
    protected int mLayoutWidth = 0;
    protected RectF mCircleBounds = new RectF();
    protected RectF mInnerCircleBound = new RectF();
    protected PointF mCenter;
    protected RectF mOuterTextBounds = new RectF();
    protected RectF mActualTextBounds = new RectF();
    protected RectF mUnitBounds = new RectF();
    protected RectF mCircleOuterContour = new RectF();
    protected RectF mCircleInnerContour = new RectF();
    Direction mDirection = Direction.CW;
    float mCurrentValue = 0.0f;
    float mValueTo = 0.0f;
    float mValueFrom = 0.0f;
    float mMaxValue = 100.0f;
    float mMinValueAllowed = 0.0f;
    float mMaxValueAllowed = -1.0f;
    float mSpinningBarLengthCurrent = 0.0f;
    float mSpinningBarLengthOrig = 42.0f;
    float mCurrentSpinnerDegreeValue = 0.0f;
    float mSpinSpeed = 2.8f;
    boolean mSpin = false;
    double mAnimationDuration = 900.0;
    int mFrameDelayMillis = 10;
    boolean mDrawBarWhileSpinning;
    AnimationHandler mAnimationHandler = new AnimationHandler(this);
    AnimationState mAnimationState = AnimationState.IDLE;
    AnimationStateChangedListener mAnimationStateChangedListener;
    private int mBarWidth = 40;
    private int mRimWidth = 40;
    private int mStartAngle = 270;
    private float mOuterContourSize = 1.0f;
    private float mInnerContourSize = 1.0f;
    private int mBarStartEndLineWidth = 0;
    private BarStartEndLine mBarStartEndLine = BarStartEndLine.NONE;
    private int mBarStartEndLineColor = -1442840576;
    private float mBarStartEndLineSweep = 10.0f;
    private int mUnitTextSize = 10;
    private int mTextSize = 10;
    private float mTextScale = 1.0f;
    private float mUnitScale = 1.0f;
    private int mOuterContourColor = -1442840576;
    private int mInnerContourColor = -1442840576;
    private int mSpinnerColor = -16738680;
    private int mBackgroundCircleColor = 0;
    private int mRimColor = -1434201911;
    private int mTextColor = -16777216;
    private int mUnitColor = -16777216;
    private boolean mIsAutoColorEnabled = false;
    private int[] mBarColors = new int[]{-16738680};
    private Paint.Cap mBarStrokeCap = Paint.Cap.BUTT;
    private Paint.Cap mSpinnerStrokeCap = Paint.Cap.BUTT;
    private Paint mBarPaint = new Paint();
    private Paint mShaderlessBarPaint;
    private Paint mBarSpinnerPaint = new Paint();
    private Paint mBarStartEndLinePaint = new Paint();
    private Paint mBackgroundCirclePaint = new Paint();
    private Paint mRimPaint = new Paint();
    private Paint mTextPaint = new Paint();
    private Paint mUnitTextPaint = new Paint();
    private Paint mOuterContourPaint = new Paint();
    private Paint mInnerContourPaint = new Paint();
    private String mText = "";
    private int mTextLength;
    private String mUnit = "";
    private UnitPosition mUnitPosition = UnitPosition.RIGHT_TOP;
    private TextMode mTextMode = TextMode.PERCENT;
    private boolean mIsAutoTextSize;
    private boolean mShowUnit = false;
    private Bitmap mClippingBitmap;
    private Paint mMaskPaint;
    private float mRelativeUniteSize = 1.0f;
    private boolean mSeekModeEnabled = false;
    private boolean mShowTextWhileSpinning = false;
    private boolean mShowBlock = false;
    private int mBlockCount = 18;
    private float mBlockScale = 0.9f;
    private float mBlockDegree = 360 / this.mBlockCount;
    private float mBlockScaleDegree = this.mBlockDegree * this.mBlockScale;
    private boolean mRoundToBlock = false;
    private boolean mRoundToWholeNumber = false;
    private int mTouchEventCount;
    private OnProgressChangedListener onProgressChangedListener;
    private float previousProgressChangedValue;
    private DecimalFormat decimalFormat = new DecimalFormat("0");
    private Typeface textTypeface;
    private Typeface unitTextTypeface;

    public CircleProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributes(context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView));
        if (!this.isInEditMode() && Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        this.mMaskPaint = new Paint(1);
        this.mMaskPaint.setFilterBitmap(false);
        this.mMaskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.setupPaints();
        if (this.mSpin) {
            this.spin();
        }
    }

    private static float calcTextSizeForRect(String _text, Paint _textPaint, RectF _rectBounds) {
        Matrix matrix = new Matrix();
        Rect textBoundsTmp = new Rect();
        String text = _text.replace('1', '0');
        _textPaint.getTextBounds(text, 0, text.length(), textBoundsTmp);
        RectF textBoundsTmpF = new RectF(textBoundsTmp);
        matrix.setRectToRect(textBoundsTmpF, _rectBounds, Matrix.ScaleToFit.CENTER);
        float[] values = new float[9];
        matrix.getValues(values);
        return _textPaint.getTextSize() * values[0];
    }

    private static float normalizeAngle(float _angle) {
        return (_angle % 360.0f + 360.0f) % 360.0f;
    }

    public static double calcRotationAngleInDegrees(PointF centerPt, PointF targetPt) {
        double theta = Math.atan2(targetPt.y - centerPt.y, targetPt.x - centerPt.x);
        double angle = Math.toDegrees(theta);
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public BarStartEndLine getBarStartEndLine() {
        return this.mBarStartEndLine;
    }

    public void setBarStartEndLine(int _barWidth, BarStartEndLine _barStartEndLine, @ColorInt int _lineColor, float _sweepWidth) {
        this.mBarStartEndLineWidth = _barWidth;
        this.mBarStartEndLine = _barStartEndLine;
        this.mBarStartEndLineColor = _lineColor;
        this.mBarStartEndLineSweep = _sweepWidth;
    }

    public int[] getBarColors() {
        return this.mBarColors;
    }

    public Paint.Cap getBarStrokeCap() {
        return this.mBarStrokeCap;
    }

    public void setBarStrokeCap(Paint.Cap _barStrokeCap) {
        this.mBarStrokeCap = _barStrokeCap;
        this.mBarPaint.setStrokeCap(_barStrokeCap);
        if (this.mBarStrokeCap != Paint.Cap.BUTT) {
            this.mShaderlessBarPaint = new Paint(this.mBarPaint);
            this.mShaderlessBarPaint.setShader(null);
            this.mShaderlessBarPaint.setColor(this.mBarColors[0]);
        }
    }

    public int getBarWidth() {
        return this.mBarWidth;
    }

    public void setBarWidth(@IntRange(from=0L) int barWidth) {
        this.mBarWidth = barWidth;
        this.mBarPaint.setStrokeWidth((float)barWidth);
        this.mBarSpinnerPaint.setStrokeWidth((float)barWidth);
    }

    public int getBlockCount() {
        return this.mBlockCount;
    }

    public void setBlockCount(int blockCount) {
        if (blockCount > 1) {
            this.mShowBlock = true;
            this.mBlockCount = blockCount;
            this.mBlockDegree = 360.0f / (float)blockCount;
            this.mBlockScaleDegree = this.mBlockDegree * this.mBlockScale;
        } else {
            this.mShowBlock = false;
        }
    }

    public void setRoundToBlock(boolean _roundToBlock) {
        this.mRoundToBlock = _roundToBlock;
    }

    public boolean getRoundToBlock() {
        return this.mRoundToBlock;
    }

    public void setRoundToWholeNumber(boolean roundToWholeNumber) {
        this.mRoundToWholeNumber = roundToWholeNumber;
    }

    public boolean getRoundToWholeNumber() {
        return this.mRoundToWholeNumber;
    }

    public float getBlockScale() {
        return this.mBlockScale;
    }

    public void setBlockScale(@FloatRange(from=0.0, to=1.0) float blockScale) {
        if (blockScale >= 0.0f && blockScale <= 1.0f) {
            this.mBlockScale = blockScale;
            this.mBlockScaleDegree = this.mBlockDegree * blockScale;
        }
    }

    public int getOuterContourColor() {
        return this.mOuterContourColor;
    }

    public void setOuterContourColor(@ColorInt int _contourColor) {
        this.mOuterContourColor = _contourColor;
        this.mOuterContourPaint.setColor(_contourColor);
    }

    public float getOuterContourSize() {
        return this.mOuterContourSize;
    }

    public void setOuterContourSize(@FloatRange(from=0.0) float _contourSize) {
        this.mOuterContourSize = _contourSize;
        this.mOuterContourPaint.setStrokeWidth(_contourSize);
    }

    public int getInnerContourColor() {
        return this.mInnerContourColor;
    }

    public void setInnerContourColor(@ColorInt int _contourColor) {
        this.mInnerContourColor = _contourColor;
        this.mInnerContourPaint.setColor(_contourColor);
    }

    public float getInnerContourSize() {
        return this.mInnerContourSize;
    }

    public void setInnerContourSize(@FloatRange(from=0.0) float _contourSize) {
        this.mInnerContourSize = _contourSize;
        this.mInnerContourPaint.setStrokeWidth(_contourSize);
    }

    public int getDelayMillis() {
        return this.mFrameDelayMillis;
    }

    public void setDelayMillis(int delayMillis) {
        this.mFrameDelayMillis = delayMillis;
    }

    public int getFillColor() {
        return this.mBackgroundCirclePaint.getColor();
    }

    public float getCurrentValue() {
        return this.mCurrentValue;
    }

    public float getMinValueAllowed() {
        return this.mMinValueAllowed;
    }

    public float getMaxValueAllowed() {
        return this.mMaxValueAllowed;
    }

    public float getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(@FloatRange(from=0.0) float _maxValue) {
        this.mMaxValue = _maxValue;
    }

    public void setMinValueAllowed(@FloatRange(from=0.0) float _minValueAllowed) {
        this.mMinValueAllowed = _minValueAllowed;
    }

    public void setMaxValueAllowed(@FloatRange(from=0.0) float _maxValueAllowed) {
        this.mMaxValueAllowed = _maxValueAllowed;
    }

    public float getRelativeUniteSize() {
        return this.mRelativeUniteSize;
    }

    public int getRimColor() {
        return this.mRimColor;
    }

    public void setRimColor(@ColorInt int rimColor) {
        this.mRimColor = rimColor;
        this.mRimPaint.setColor(rimColor);
    }

    public Shader getRimShader() {
        return this.mRimPaint.getShader();
    }

    public void setRimShader(Shader shader) {
        this.mRimPaint.setShader(shader);
    }

    public int getRimWidth() {
        return this.mRimWidth;
    }

    public void setRimWidth(@IntRange(from=0L) int rimWidth) {
        this.mRimWidth = rimWidth;
        this.mRimPaint.setStrokeWidth((float)rimWidth);
    }

    public float getSpinSpeed() {
        return this.mSpinSpeed;
    }

    public void setSpinSpeed(float spinSpeed) {
        this.mSpinSpeed = spinSpeed;
    }

    public Paint.Cap getSpinnerStrokeCap() {
        return this.mSpinnerStrokeCap;
    }

    public void setSpinnerStrokeCap(Paint.Cap _spinnerStrokeCap) {
        this.mSpinnerStrokeCap = _spinnerStrokeCap;
        this.mBarSpinnerPaint.setStrokeCap(_spinnerStrokeCap);
    }

    public int getStartAngle() {
        return this.mStartAngle;
    }

    public void setStartAngle(@IntRange(from=0L, to=360L) int _startAngle) {
        this.mStartAngle = (int)CircleProgressView.normalizeAngle(_startAngle);
    }

    public int calcTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(textColor);
    }

    public float getTextScale() {
        return this.mTextScale;
    }

    public void setTextScale(@FloatRange(from=0.0) float _textScale) {
        this.mTextScale = _textScale;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(@IntRange(from=0L) int textSize) {
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextSize = textSize;
        this.mIsAutoTextSize = false;
    }

    public String getUnit() {
        return this.mUnit;
    }

    public void setUnit(String _unit) {
        this.mUnit = _unit == null ? "" : _unit;
        this.invalidate();
    }

    public float getUnitScale() {
        return this.mUnitScale;
    }

    public void setUnitScale(@FloatRange(from=0.0) float _unitScale) {
        this.mUnitScale = _unitScale;
    }

    public int getUnitSize() {
        return this.mUnitTextSize;
    }

    public void setUnitSize(@IntRange(from=0L) int unitSize) {
        this.mUnitTextSize = unitSize;
        this.mUnitTextPaint.setTextSize((float)unitSize);
    }

    public boolean isAutoTextSize() {
        return this.mIsAutoTextSize;
    }

    public void setAutoTextSize(boolean _autoTextSize) {
        this.mIsAutoTextSize = _autoTextSize;
    }

    public boolean isSeekModeEnabled() {
        return this.mSeekModeEnabled;
    }

    public void setSeekModeEnabled(boolean _seekModeEnabled) {
        this.mSeekModeEnabled = _seekModeEnabled;
    }

    public boolean isShowBlock() {
        return this.mShowBlock;
    }

    public void setShowBlock(boolean showBlock) {
        this.mShowBlock = showBlock;
    }

    public boolean isShowTextWhileSpinning() {
        return this.mShowTextWhileSpinning;
    }

    public void setShowTextWhileSpinning(boolean shouldDrawTextWhileSpinning) {
        this.mShowTextWhileSpinning = shouldDrawTextWhileSpinning;
    }

    public boolean isUnitVisible() {
        return this.mShowUnit;
    }

    public void setUnitVisible(boolean _showUnit) {
        if (_showUnit != this.mShowUnit) {
            this.mShowUnit = _showUnit;
            this.triggerReCalcTextSizesAndPositions();
        }
    }

    public void setBarColor(int ... barColors) {
        this.mBarColors = barColors;
        this.setupBarPaint();
    }

    @TargetApi(value=11)
    public void setClippingBitmap(Bitmap _clippingBitmap) {
        this.mClippingBitmap = this.getWidth() > 0 && this.getHeight() > 0 ? Bitmap.createScaledBitmap((Bitmap)_clippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false) : _clippingBitmap;
        if (this.mClippingBitmap == null) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
        }
    }

    public void setFillCircleColor(@ColorInt int circleColor) {
        this.mBackgroundCircleColor = circleColor;
        this.mBackgroundCirclePaint.setColor(circleColor);
    }

    public void setOnAnimationStateChangedListener(AnimationStateChangedListener _animationStateChangedListener) {
        this.mAnimationStateChangedListener = _animationStateChangedListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener listener) {
        this.onProgressChangedListener = listener;
    }

    public void setSpinBarColor(@ColorInt int _color) {
        this.mSpinnerColor = _color;
        this.mBarSpinnerPaint.setColor(this.mSpinnerColor);
    }

    public void setSpinningBarLength(@FloatRange(from=0.0) float barLength) {
        this.mSpinningBarLengthCurrent = this.mSpinningBarLengthOrig = barLength;
    }

    public void setText(String text) {
        this.mText = text != null ? text : "";
        this.invalidate();
    }

    public void setTextColorAuto(boolean isEnabled) {
        this.mIsAutoColorEnabled = isEnabled;
    }

    public void setTextMode(TextMode _textValue) {
        this.mTextMode = _textValue;
    }

    public void setTextTypeface(Typeface typeface) {
        this.mTextPaint.setTypeface(typeface);
    }

    public void setUnitColor(@ColorInt int unitColor) {
        this.mUnitColor = unitColor;
        this.mUnitTextPaint.setColor(unitColor);
        this.mIsAutoColorEnabled = false;
    }

    public void setUnitPosition(UnitPosition _unitPosition) {
        this.mUnitPosition = _unitPosition;
        this.triggerReCalcTextSizesAndPositions();
    }

    public void setUnitTextTypeface(Typeface typeface) {
        this.mUnitTextPaint.setTypeface(typeface);
    }

    public void setUnitToTextScale(@FloatRange(from=0.0) float _relativeUniteSize) {
        this.mRelativeUniteSize = _relativeUniteSize;
        this.triggerReCalcTextSizesAndPositions();
    }

    public void setDirection(Direction direction) {
        this.mDirection = direction;
    }

    public void setValue(float _value) {
        if (this.mShowBlock && this.mRoundToBlock) {
            float value_per_block = this.mMaxValue / (float)this.mBlockCount;
            _value = (float)Math.round(_value / value_per_block) * value_per_block;
        } else if (this.mRoundToWholeNumber) {
            _value = Math.round(_value);
        }
        _value = Math.max(this.mMinValueAllowed, _value);
        if (this.mMaxValueAllowed >= 0.0f) {
            _value = Math.min(this.mMaxValueAllowed, _value);
        }
        Message msg = new Message();
        msg.what = AnimationMsg.SET_VALUE.ordinal();
        msg.obj = new float[]{_value, _value};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_value);
    }

    public void setValueAnimated(float _valueTo) {
        this.setValueAnimated(_valueTo, 1200L);
    }

    public void setValueAnimated(float _valueTo, long _animationDuration) {
        this.setValueAnimated(this.mCurrentValue, _valueTo, _animationDuration);
    }

    public void setValueAnimated(float _valueFrom, float _valueTo, long _animationDuration) {
        if (this.mShowBlock && this.mRoundToBlock) {
            float value_per_block = this.mMaxValue / (float)this.mBlockCount;
            _valueTo = (float)Math.round(_valueTo / value_per_block) * value_per_block;
        } else if (this.mRoundToWholeNumber) {
            _valueTo = Math.round(_valueTo);
        }
        _valueTo = Math.max(this.mMinValueAllowed, _valueTo);
        if (this.mMaxValueAllowed >= 0.0f) {
            _valueTo = Math.min(this.mMaxValueAllowed, _valueTo);
        }
        this.mAnimationDuration = _animationDuration;
        Message msg = new Message();
        msg.what = AnimationMsg.SET_VALUE_ANIMATED.ordinal();
        msg.obj = new float[]{_valueFrom, _valueTo};
        this.mAnimationHandler.sendMessage(msg);
        this.triggerOnProgressChanged(_valueTo);
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            throw new IllegalArgumentException("decimalFormat must not be null!");
        }
        this.decimalFormat = decimalFormat;
    }

    public void setValueInterpolator(TimeInterpolator interpolator) {
        this.mAnimationHandler.setValueInterpolator(interpolator);
    }

    public void setLengthChangeInterpolator(TimeInterpolator interpolator) {
        this.mAnimationHandler.setLengthChangeInterpolator(interpolator);
    }

    private void parseAttributes(TypedArray a) {
        this.setBarWidth((int)a.getDimension(R.styleable.CircleProgressView_cpv_barWidth, (float)this.mBarWidth));
        this.setRimWidth((int)a.getDimension(R.styleable.CircleProgressView_cpv_rimWidth, (float)this.mRimWidth));
        this.setSpinSpeed((int)a.getFloat(R.styleable.CircleProgressView_cpv_spinSpeed, this.mSpinSpeed));
        this.setSpin(a.getBoolean(R.styleable.CircleProgressView_cpv_spin, this.mSpin));
        this.setDirection(Direction.values()[a.getInt(R.styleable.CircleProgressView_cpv_direction, 0)]);
        float value = a.getFloat(R.styleable.CircleProgressView_cpv_value, this.mCurrentValue);
        this.setValue(value);
        this.mCurrentValue = value;
        this.mBarColors = a.hasValue(R.styleable.CircleProgressView_cpv_barColor) && a.hasValue(R.styleable.CircleProgressView_cpv_barColor1) && a.hasValue(R.styleable.CircleProgressView_cpv_barColor2) && a.hasValue(R.styleable.CircleProgressView_cpv_barColor3) ? new int[]{a.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor1, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor2, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor3, -16738680)} : (a.hasValue(R.styleable.CircleProgressView_cpv_barColor) && a.hasValue(R.styleable.CircleProgressView_cpv_barColor1) && a.hasValue(R.styleable.CircleProgressView_cpv_barColor2) ? new int[]{a.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor1, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor2, -16738680)} : (a.hasValue(R.styleable.CircleProgressView_cpv_barColor) && a.hasValue(R.styleable.CircleProgressView_cpv_barColor1) ? new int[]{a.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor1, -16738680)} : new int[]{a.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680), a.getColor(R.styleable.CircleProgressView_cpv_barColor, -16738680)}));
        if (a.hasValue(R.styleable.CircleProgressView_cpv_barStrokeCap)) {
            this.setBarStrokeCap(StrokeCap.values()[a.getInt((int)R.styleable.CircleProgressView_cpv_barStrokeCap, (int)0)].paintCap);
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_barStartEndLineWidth) && a.hasValue(R.styleable.CircleProgressView_cpv_barStartEndLine)) {
            this.setBarStartEndLine((int)a.getDimension(R.styleable.CircleProgressView_cpv_barStartEndLineWidth, 0.0f), BarStartEndLine.values()[a.getInt(R.styleable.CircleProgressView_cpv_barStartEndLine, 3)], a.getColor(R.styleable.CircleProgressView_cpv_barStartEndLineColor, this.mBarStartEndLineColor), a.getFloat(R.styleable.CircleProgressView_cpv_barStartEndLineSweep, this.mBarStartEndLineSweep));
        }
        this.setSpinBarColor(a.getColor(R.styleable.CircleProgressView_cpv_spinColor, this.mSpinnerColor));
        this.setSpinningBarLength(a.getFloat(R.styleable.CircleProgressView_cpv_spinBarLength, this.mSpinningBarLengthOrig));
        if (a.hasValue(R.styleable.CircleProgressView_cpv_textSize)) {
            this.setTextSize((int)a.getDimension(R.styleable.CircleProgressView_cpv_textSize, (float)this.mTextSize));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_unitSize)) {
            this.setUnitSize((int)a.getDimension(R.styleable.CircleProgressView_cpv_unitSize, (float)this.mUnitTextSize));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_textColor)) {
            this.setTextColor(a.getColor(R.styleable.CircleProgressView_cpv_textColor, this.mTextColor));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_unitColor)) {
            this.setUnitColor(a.getColor(R.styleable.CircleProgressView_cpv_unitColor, this.mUnitColor));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_autoTextColor)) {
            this.setTextColorAuto(a.getBoolean(R.styleable.CircleProgressView_cpv_autoTextColor, this.mIsAutoColorEnabled));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_autoTextSize)) {
            this.setAutoTextSize(a.getBoolean(R.styleable.CircleProgressView_cpv_autoTextSize, this.mIsAutoTextSize));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_textMode)) {
            this.setTextMode(TextMode.values()[a.getInt(R.styleable.CircleProgressView_cpv_textMode, 0)]);
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_unitPosition)) {
            this.setUnitPosition(UnitPosition.values()[a.getInt(R.styleable.CircleProgressView_cpv_unitPosition, 3)]);
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_text)) {
            this.setText(a.getString(R.styleable.CircleProgressView_cpv_text));
        }
        this.setUnitToTextScale(a.getFloat(R.styleable.CircleProgressView_cpv_unitToTextScale, 1.0f));
        this.setRimColor(a.getColor(R.styleable.CircleProgressView_cpv_rimColor, this.mRimColor));
        this.setFillCircleColor(a.getColor(R.styleable.CircleProgressView_cpv_fillColor, this.mBackgroundCircleColor));
        this.setOuterContourColor(a.getColor(R.styleable.CircleProgressView_cpv_outerContourColor, this.mOuterContourColor));
        this.setOuterContourSize(a.getDimension(R.styleable.CircleProgressView_cpv_outerContourSize, this.mOuterContourSize));
        this.setInnerContourColor(a.getColor(R.styleable.CircleProgressView_cpv_innerContourColor, this.mInnerContourColor));
        this.setInnerContourSize(a.getDimension(R.styleable.CircleProgressView_cpv_innerContourSize, this.mInnerContourSize));
        this.setMaxValue(a.getFloat(R.styleable.CircleProgressView_cpv_maxValue, this.mMaxValue));
        this.setMinValueAllowed(a.getFloat(R.styleable.CircleProgressView_cpv_minValueAllowed, this.mMinValueAllowed));
        this.setMaxValueAllowed(a.getFloat(R.styleable.CircleProgressView_cpv_maxValueAllowed, this.mMaxValueAllowed));
        this.setRoundToBlock(a.getBoolean(R.styleable.CircleProgressView_cpv_roundToBlock, this.mRoundToBlock));
        this.setRoundToWholeNumber(a.getBoolean(R.styleable.CircleProgressView_cpv_roundToWholeNumber, this.mRoundToWholeNumber));
        this.setUnit(a.getString(R.styleable.CircleProgressView_cpv_unit));
        this.setUnitVisible(a.getBoolean(R.styleable.CircleProgressView_cpv_showUnit, this.mShowUnit));
        this.setTextScale(a.getFloat(R.styleable.CircleProgressView_cpv_textScale, this.mTextScale));
        this.setUnitScale(a.getFloat(R.styleable.CircleProgressView_cpv_unitScale, this.mUnitScale));
        this.setSeekModeEnabled(a.getBoolean(R.styleable.CircleProgressView_cpv_seekMode, this.mSeekModeEnabled));
        this.setStartAngle(a.getInt(R.styleable.CircleProgressView_cpv_startAngle, this.mStartAngle));
        this.setShowTextWhileSpinning(a.getBoolean(R.styleable.CircleProgressView_cpv_showTextInSpinningMode, this.mShowTextWhileSpinning));
        if (a.hasValue(R.styleable.CircleProgressView_cpv_blockCount)) {
            this.setBlockCount(a.getInt(R.styleable.CircleProgressView_cpv_blockCount, 1));
            this.setBlockScale(a.getFloat(R.styleable.CircleProgressView_cpv_blockScale, 0.9f));
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_textTypeface)) {
            try {
                this.textTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)a.getString(R.styleable.CircleProgressView_cpv_textTypeface));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_unitTypeface)) {
            try {
                this.unitTextTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)a.getString(R.styleable.CircleProgressView_cpv_unitTypeface));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (a.hasValue(R.styleable.CircleProgressView_cpv_decimalFormat)) {
            try {
                String pattern = a.getString(R.styleable.CircleProgressView_cpv_decimalFormat);
                if (pattern != null) {
                    this.decimalFormat = new DecimalFormat(pattern);
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)exception.getMessage());
            }
        }
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heightWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        int size = widthWithoutPadding > heightWithoutPadding ? heightWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mLayoutWidth = w;
        this.mLayoutHeight = h;
        this.setupBounds();
        this.setupBarPaint();
        if (this.mClippingBitmap != null) {
            this.mClippingBitmap = Bitmap.createScaledBitmap((Bitmap)this.mClippingBitmap, (int)this.getWidth(), (int)this.getHeight(), (boolean)false);
        }
        this.invalidate();
    }

    private float calcTextSizeForCircle(String _text, Paint _textPaint, RectF _circleBounds) {
        RectF innerCircleBounds = this.getInnerCircleRect(_circleBounds);
        return CircleProgressView.calcTextSizeForRect(_text, _textPaint, innerCircleBounds);
    }

    private RectF getInnerCircleRect(RectF _circleBounds) {
        double circleWidth = _circleBounds.width() - (float)Math.max(this.mBarWidth, this.mRimWidth) - this.mOuterContourSize - this.mInnerContourSize;
        double width = circleWidth / 2.0 * Math.sqrt(2.0);
        float widthDelta = (_circleBounds.width() - (float)width) / 2.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (this.isUnitVisible()) {
            switch (this.mUnitPosition) {
                case TOP: 
                case BOTTOM: {
                    scaleX = 1.1f;
                    scaleY = 0.88f;
                    break;
                }
                case LEFT_TOP: 
                case RIGHT_TOP: 
                case LEFT_BOTTOM: 
                case RIGHT_BOTTOM: {
                    scaleX = 0.77f;
                    scaleY = 1.33f;
                }
            }
        }
        return new RectF(_circleBounds.left + widthDelta * scaleX, _circleBounds.top + widthDelta * scaleY, _circleBounds.right - widthDelta * scaleX, _circleBounds.bottom - widthDelta * scaleY);
    }

    private void triggerOnProgressChanged(float value) {
        if (this.onProgressChangedListener != null && value != this.previousProgressChangedValue) {
            this.onProgressChangedListener.onProgressChanged(value);
            this.previousProgressChangedValue = value;
        }
    }

    private void triggerReCalcTextSizesAndPositions() {
        this.mTextLength = -1;
        this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
        this.invalidate();
    }

    private int calcTextColor(double value) {
        if (this.mBarColors.length > 1) {
            double percent = (double)(1.0f / this.getMaxValue()) * value;
            int low = (int)Math.floor((double)(this.mBarColors.length - 1) * percent);
            int high = low + 1;
            if (low < 0) {
                low = 0;
                high = 1;
            } else if (high >= this.mBarColors.length) {
                low = this.mBarColors.length - 2;
                high = this.mBarColors.length - 1;
            }
            return ColorUtils.getRGBGradient(this.mBarColors[low], this.mBarColors[high], (float)(1.0 - (double)(this.mBarColors.length - 1) * percent % 1.0));
        }
        if (this.mBarColors.length == 1) {
            return this.mBarColors[0];
        }
        return -16777216;
    }

    private void setTextSizeAndTextBoundsWithAutoTextSize(float unitGapWidthHalf, float unitWidth, float unitGapHeightHalf, float unitHeight, String text) {
        RectF textRect = this.mOuterTextBounds;
        if (this.mShowUnit) {
            switch (this.mUnitPosition) {
                case TOP: {
                    textRect = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.top + unitHeight + unitGapHeightHalf, this.mOuterTextBounds.right, this.mOuterTextBounds.bottom);
                    break;
                }
                case BOTTOM: {
                    textRect = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.top, this.mOuterTextBounds.right, this.mOuterTextBounds.bottom - unitHeight - unitGapHeightHalf);
                    break;
                }
                case LEFT_TOP: 
                case LEFT_BOTTOM: {
                    textRect = new RectF(this.mOuterTextBounds.left + unitWidth + unitGapWidthHalf, this.mOuterTextBounds.top, this.mOuterTextBounds.right, this.mOuterTextBounds.bottom);
                    break;
                }
                default: {
                    textRect = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.top, this.mOuterTextBounds.right - unitWidth - unitGapWidthHalf, this.mOuterTextBounds.bottom);
                }
            }
        }
        this.mTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(text, this.mTextPaint, textRect) * this.mTextScale);
        this.mActualTextBounds = this.calcTextBounds(text, this.mTextPaint, textRect);
    }

    private void setTextSizeAndTextBoundsWithFixedTextSize(String text) {
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mActualTextBounds = this.calcTextBounds(text, this.mTextPaint, this.mCircleBounds);
    }

    private void setUnitTextBoundsAndSizeWithAutoTextSize(float unitGapWidthHalf, float unitWidth, float unitGapHeightHalf, float unitHeight) {
        switch (this.mUnitPosition) {
            case TOP: {
                this.mUnitBounds = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.top, this.mOuterTextBounds.right, this.mOuterTextBounds.top + unitHeight - unitGapHeightHalf);
                break;
            }
            case BOTTOM: {
                this.mUnitBounds = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.bottom - unitHeight + unitGapHeightHalf, this.mOuterTextBounds.right, this.mOuterTextBounds.bottom);
                break;
            }
            case LEFT_TOP: 
            case LEFT_BOTTOM: {
                this.mUnitBounds = new RectF(this.mOuterTextBounds.left, this.mOuterTextBounds.top, this.mOuterTextBounds.left + unitWidth - unitGapWidthHalf, this.mOuterTextBounds.top + unitHeight);
                break;
            }
            default: {
                this.mUnitBounds = new RectF(this.mOuterTextBounds.right - unitWidth + unitGapWidthHalf, this.mOuterTextBounds.top, this.mOuterTextBounds.right, this.mOuterTextBounds.top + unitHeight);
            }
        }
        this.mUnitTextPaint.setTextSize(CircleProgressView.calcTextSizeForRect(this.mUnit, this.mUnitTextPaint, this.mUnitBounds) * this.mUnitScale);
        this.mUnitBounds = this.calcTextBounds(this.mUnit, this.mUnitTextPaint, this.mUnitBounds);
        switch (this.mUnitPosition) {
            case LEFT_TOP: 
            case RIGHT_TOP: {
                float dy = this.mActualTextBounds.top - this.mUnitBounds.top;
                this.mUnitBounds.offset(0.0f, dy);
                break;
            }
            case LEFT_BOTTOM: 
            case RIGHT_BOTTOM: {
                float dy = this.mActualTextBounds.bottom - this.mUnitBounds.bottom;
                this.mUnitBounds.offset(0.0f, dy);
                break;
            }
        }
    }

    private void setUnitTextBoundsAndSizeWithFixedTextSize(float unitGapWidth, float unitGapHeight) {
        this.mUnitTextPaint.setTextSize((float)this.mUnitTextSize);
        this.mUnitBounds = this.calcTextBounds(this.mUnit, this.mUnitTextPaint, this.mOuterTextBounds);
        switch (this.mUnitPosition) {
            case TOP: {
                this.mUnitBounds.offsetTo(this.mUnitBounds.left, this.mActualTextBounds.top - unitGapHeight - this.mUnitBounds.height());
                break;
            }
            case BOTTOM: {
                this.mUnitBounds.offsetTo(this.mUnitBounds.left, this.mActualTextBounds.bottom + unitGapHeight);
                break;
            }
            case LEFT_TOP: 
            case LEFT_BOTTOM: {
                this.mUnitBounds.offsetTo(this.mActualTextBounds.left - unitGapWidth - this.mUnitBounds.width(), this.mUnitBounds.top);
                break;
            }
            default: {
                this.mUnitBounds.offsetTo(this.mActualTextBounds.right + unitGapWidth, this.mUnitBounds.top);
            }
        }
        switch (this.mUnitPosition) {
            case LEFT_TOP: 
            case RIGHT_TOP: {
                float dy = this.mActualTextBounds.top - this.mUnitBounds.top;
                this.mUnitBounds.offset(0.0f, dy);
                break;
            }
            case LEFT_BOTTOM: 
            case RIGHT_BOTTOM: {
                float dy = this.mActualTextBounds.bottom - this.mUnitBounds.bottom;
                this.mUnitBounds.offset(0.0f, dy);
                break;
            }
        }
    }

    private RectF calcTextBounds(String _text, Paint _textPaint, RectF _textBounds) {
        Rect textBoundsTmp = new Rect();
        _textPaint.getTextBounds(_text, 0, _text.length(), textBoundsTmp);
        float width = textBoundsTmp.left + textBoundsTmp.width();
        float height = (float)textBoundsTmp.bottom + (float)textBoundsTmp.height() * 0.93f;
        RectF textRect = new RectF();
        textRect.left = _textBounds.left + (_textBounds.width() - width) / 2.0f;
        textRect.top = _textBounds.top + (_textBounds.height() - height) / 2.0f;
        textRect.right = textRect.left + width;
        textRect.bottom = textRect.top + height;
        return textRect;
    }

    private void setupBounds() {
        int minValue = Math.min(this.mLayoutWidth, this.mLayoutHeight);
        int xOffset = this.mLayoutWidth - minValue;
        int yOffset = this.mLayoutHeight - minValue;
        float paddingTop = this.getPaddingTop() + yOffset / 2;
        float paddingBottom = this.getPaddingBottom() + yOffset / 2;
        float paddingLeft = this.getPaddingLeft() + xOffset / 2;
        float paddingRight = this.getPaddingRight() + xOffset / 2;
        int width = this.getWidth();
        int height = this.getHeight();
        float circleWidthHalf = (float)this.mBarWidth / 2.0f > (float)this.mRimWidth / 2.0f + this.mOuterContourSize ? (float)this.mBarWidth / 2.0f : (float)this.mRimWidth / 2.0f + this.mOuterContourSize;
        this.mCircleBounds = new RectF(paddingLeft + circleWidthHalf, paddingTop + circleWidthHalf, (float)width - paddingRight - circleWidthHalf, (float)height - paddingBottom - circleWidthHalf);
        this.mInnerCircleBound = new RectF(paddingLeft + (float)this.mBarWidth, paddingTop + (float)this.mBarWidth, (float)width - paddingRight - (float)this.mBarWidth, (float)height - paddingBottom - (float)this.mBarWidth);
        this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
        this.mCircleInnerContour = new RectF(this.mCircleBounds.left + (float)this.mRimWidth / 2.0f + this.mInnerContourSize / 2.0f, this.mCircleBounds.top + (float)this.mRimWidth / 2.0f + this.mInnerContourSize / 2.0f, this.mCircleBounds.right - (float)this.mRimWidth / 2.0f - this.mInnerContourSize / 2.0f, this.mCircleBounds.bottom - (float)this.mRimWidth / 2.0f - this.mInnerContourSize / 2.0f);
        this.mCircleOuterContour = new RectF(this.mCircleBounds.left - (float)this.mRimWidth / 2.0f - this.mOuterContourSize / 2.0f, this.mCircleBounds.top - (float)this.mRimWidth / 2.0f - this.mOuterContourSize / 2.0f, this.mCircleBounds.right + (float)this.mRimWidth / 2.0f + this.mOuterContourSize / 2.0f, this.mCircleBounds.bottom + (float)this.mRimWidth / 2.0f + this.mOuterContourSize / 2.0f);
        this.mCenter = new PointF(this.mCircleBounds.centerX(), this.mCircleBounds.centerY());
    }

    private void setupBarPaint() {
        if (this.mBarColors.length > 1) {
            this.mBarPaint.setShader((Shader)new SweepGradient(this.mCircleBounds.centerX(), this.mCircleBounds.centerY(), this.mBarColors, null));
            Matrix matrix = new Matrix();
            this.mBarPaint.getShader().getLocalMatrix(matrix);
            matrix.postTranslate(-this.mCircleBounds.centerX(), -this.mCircleBounds.centerY());
            matrix.postRotate((float)this.mStartAngle);
            matrix.postTranslate(this.mCircleBounds.centerX(), this.mCircleBounds.centerY());
            this.mBarPaint.getShader().setLocalMatrix(matrix);
            this.mBarPaint.setColor(this.mBarColors[0]);
        } else if (this.mBarColors.length == 1) {
            this.mBarPaint.setColor(this.mBarColors[0]);
            this.mBarPaint.setShader(null);
        } else {
            this.mBarPaint.setColor(-16738680);
            this.mBarPaint.setShader(null);
        }
        this.mBarPaint.setAntiAlias(true);
        this.mBarPaint.setStrokeCap(this.mBarStrokeCap);
        this.mBarPaint.setStyle(Paint.Style.STROKE);
        this.mBarPaint.setStrokeWidth((float)this.mBarWidth);
        if (this.mBarStrokeCap != Paint.Cap.BUTT) {
            this.mShaderlessBarPaint = new Paint(this.mBarPaint);
            this.mShaderlessBarPaint.setShader(null);
            this.mShaderlessBarPaint.setColor(this.mBarColors[0]);
        }
    }

    public void setupPaints() {
        this.setupBarPaint();
        this.setupBarSpinnerPaint();
        this.setupOuterContourPaint();
        this.setupInnerContourPaint();
        this.setupUnitTextPaint();
        this.setupTextPaint();
        this.setupBackgroundCirclePaint();
        this.setupRimPaint();
        this.setupBarStartEndLinePaint();
    }

    private void setupBarStartEndLinePaint() {
        this.mBarStartEndLinePaint.setColor(this.mBarStartEndLineColor);
        this.mBarStartEndLinePaint.setAntiAlias(true);
        this.mBarStartEndLinePaint.setStyle(Paint.Style.STROKE);
        this.mBarStartEndLinePaint.setStrokeWidth((float)this.mBarStartEndLineWidth);
    }

    private void setupOuterContourPaint() {
        this.mOuterContourPaint.setColor(this.mOuterContourColor);
        this.mOuterContourPaint.setAntiAlias(true);
        this.mOuterContourPaint.setStyle(Paint.Style.STROKE);
        this.mOuterContourPaint.setStrokeWidth(this.mOuterContourSize);
    }

    private void setupInnerContourPaint() {
        this.mInnerContourPaint.setColor(this.mInnerContourColor);
        this.mInnerContourPaint.setAntiAlias(true);
        this.mInnerContourPaint.setStyle(Paint.Style.STROKE);
        this.mInnerContourPaint.setStrokeWidth(this.mInnerContourSize);
    }

    private void setupUnitTextPaint() {
        this.mUnitTextPaint.setStyle(Paint.Style.FILL);
        this.mUnitTextPaint.setAntiAlias(true);
        if (this.unitTextTypeface != null) {
            this.mUnitTextPaint.setTypeface(this.unitTextTypeface);
        }
    }

    private void setupTextPaint() {
        this.mTextPaint.setSubpixelText(true);
        this.mTextPaint.setLinearText(true);
        this.mTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        if (this.textTypeface != null) {
            this.mTextPaint.setTypeface(this.textTypeface);
        } else {
            this.mTextPaint.setTypeface(Typeface.MONOSPACE);
        }
    }

    private void setupBackgroundCirclePaint() {
        this.mBackgroundCirclePaint.setColor(this.mBackgroundCircleColor);
        this.mBackgroundCirclePaint.setAntiAlias(true);
        this.mBackgroundCirclePaint.setStyle(Paint.Style.FILL);
    }

    private void setupRimPaint() {
        this.mRimPaint.setColor(this.mRimColor);
        this.mRimPaint.setAntiAlias(true);
        this.mRimPaint.setStyle(Paint.Style.STROKE);
        this.mRimPaint.setStrokeWidth((float)this.mRimWidth);
    }

    private void setupBarSpinnerPaint() {
        this.mBarSpinnerPaint.setAntiAlias(true);
        this.mBarSpinnerPaint.setStrokeCap(this.mSpinnerStrokeCap);
        this.mBarSpinnerPaint.setStyle(Paint.Style.STROKE);
        this.mBarSpinnerPaint.setStrokeWidth((float)this.mBarWidth);
        this.mBarSpinnerPaint.setColor(this.mSpinnerColor);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float degrees = 360.0f / this.mMaxValue * this.mCurrentValue;
        if (this.mBackgroundCircleColor != 0) {
            canvas.drawArc(this.mInnerCircleBound, 360.0f, 360.0f, false, this.mBackgroundCirclePaint);
        }
        if (this.mRimWidth > 0) {
            if (!this.mShowBlock) {
                canvas.drawArc(this.mCircleBounds, 360.0f, 360.0f, false, this.mRimPaint);
            } else {
                this.drawBlocks(canvas, this.mCircleBounds, this.mStartAngle, 360.0f, false, this.mRimPaint);
            }
        }
        if (this.mOuterContourSize > 0.0f) {
            canvas.drawArc(this.mCircleOuterContour, 360.0f, 360.0f, false, this.mOuterContourPaint);
        }
        if (this.mInnerContourSize > 0.0f) {
            canvas.drawArc(this.mCircleInnerContour, 360.0f, 360.0f, false, this.mInnerContourPaint);
        }
        if (this.mAnimationState == AnimationState.SPINNING || this.mAnimationState == AnimationState.END_SPINNING) {
            this.drawSpinner(canvas);
            if (this.mShowTextWhileSpinning) {
                this.drawTextWithUnit(canvas);
            }
        } else if (this.mAnimationState == AnimationState.END_SPINNING_START_ANIMATING) {
            this.drawSpinner(canvas);
            if (this.mDrawBarWhileSpinning) {
                this.drawBar(canvas, degrees);
                this.drawTextWithUnit(canvas);
            } else if (this.mShowTextWhileSpinning) {
                this.drawTextWithUnit(canvas);
            }
        } else {
            this.drawBar(canvas, degrees);
            this.drawTextWithUnit(canvas);
        }
        if (this.mClippingBitmap != null) {
            canvas.drawBitmap(this.mClippingBitmap, 0.0f, 0.0f, this.mMaskPaint);
        }
        if (this.mBarStartEndLineWidth > 0 && this.mBarStartEndLine != BarStartEndLine.NONE) {
            this.drawStartEndLine(canvas, degrees);
        }
    }

    private void drawStartEndLine(Canvas _canvas, float _degrees) {
        if (_degrees == 0.0f) {
            return;
        }
        float startAngle = this.mDirection == Direction.CW ? (float)this.mStartAngle : (float)this.mStartAngle - _degrees;
        startAngle -= this.mBarStartEndLineSweep / 2.0f;
        if (this.mBarStartEndLine == BarStartEndLine.START || this.mBarStartEndLine == BarStartEndLine.BOTH) {
            _canvas.drawArc(this.mCircleBounds, startAngle, this.mBarStartEndLineSweep, false, this.mBarStartEndLinePaint);
        }
        if (this.mBarStartEndLine == BarStartEndLine.END || this.mBarStartEndLine == BarStartEndLine.BOTH) {
            _canvas.drawArc(this.mCircleBounds, startAngle + _degrees, this.mBarStartEndLineSweep, false, this.mBarStartEndLinePaint);
        }
    }

    private void drawDebug(Canvas canvas) {
        Paint innerRectPaint = new Paint();
        innerRectPaint.setColor(-256);
        canvas.drawRect(this.mCircleBounds, innerRectPaint);
    }

    private void drawBlocks(Canvas _canvas, RectF circleBounds, float startAngle, float _degrees, boolean userCenter, Paint paint) {
        for (float tmpDegree = 0.0f; tmpDegree < _degrees; tmpDegree += this.mBlockDegree) {
            _canvas.drawArc(circleBounds, startAngle + tmpDegree, Math.min(this.mBlockScaleDegree, _degrees - tmpDegree), userCenter, paint);
        }
    }

    private void drawSpinner(Canvas canvas) {
        if (this.mSpinningBarLengthCurrent < 0.0f) {
            this.mSpinningBarLengthCurrent = 1.0f;
        }
        float startAngle = this.mDirection == Direction.CW ? (float)this.mStartAngle + this.mCurrentSpinnerDegreeValue - this.mSpinningBarLengthCurrent : (float)this.mStartAngle - this.mCurrentSpinnerDegreeValue;
        canvas.drawArc(this.mCircleBounds, startAngle, this.mSpinningBarLengthCurrent, false, this.mBarSpinnerPaint);
    }

    private void drawTextWithUnit(Canvas canvas) {
        String text;
        float relativeWidth;
        float relativeHeight;
        float relativeGapHeight;
        float relativeGapWidth;
        switch (this.mUnitPosition) {
            case TOP: 
            case BOTTOM: {
                relativeGapWidth = 0.05f;
                relativeGapHeight = 0.025f;
                relativeHeight = 0.25f * this.mRelativeUniteSize;
                relativeWidth = 0.4f * this.mRelativeUniteSize;
                break;
            }
            default: {
                relativeGapWidth = 0.05f;
                relativeGapHeight = 0.025f;
                relativeHeight = 0.55f * this.mRelativeUniteSize;
                relativeWidth = 0.3f * this.mRelativeUniteSize;
            }
        }
        float unitGapWidthHalf = this.mOuterTextBounds.width() * relativeGapWidth / 2.0f;
        float unitWidth = this.mOuterTextBounds.width() * relativeWidth;
        float unitGapHeightHalf = this.mOuterTextBounds.height() * relativeGapHeight / 2.0f;
        float unitHeight = this.mOuterTextBounds.height() * relativeHeight;
        boolean update = false;
        if (this.mIsAutoColorEnabled) {
            this.mTextPaint.setColor(this.calcTextColor(this.mCurrentValue));
        }
        switch (this.mTextMode) {
            default: {
                text = this.mText != null ? this.mText : "";
                break;
            }
            case PERCENT: {
                text = this.decimalFormat.format(100.0f / this.mMaxValue * this.mCurrentValue);
                break;
            }
            case VALUE: {
                text = this.decimalFormat.format(this.mCurrentValue);
            }
        }
        if (this.mTextLength != text.length()) {
            update = true;
            this.mTextLength = text.length();
            if (this.mTextLength == 1) {
                this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
                this.mOuterTextBounds = new RectF(this.mOuterTextBounds.left + this.mOuterTextBounds.width() * 0.1f, this.mOuterTextBounds.top, this.mOuterTextBounds.right - this.mOuterTextBounds.width() * 0.1f, this.mOuterTextBounds.bottom);
            } else {
                this.mOuterTextBounds = this.getInnerCircleRect(this.mCircleBounds);
            }
            if (this.mIsAutoTextSize) {
                this.setTextSizeAndTextBoundsWithAutoTextSize(unitGapWidthHalf, unitWidth, unitGapHeightHalf, unitHeight, text);
            } else {
                this.setTextSizeAndTextBoundsWithFixedTextSize(text);
            }
        }
        canvas.drawText(text, this.mActualTextBounds.left - this.mTextPaint.getTextSize() * 0.02f, this.mActualTextBounds.bottom, this.mTextPaint);
        if (this.mShowUnit) {
            if (this.mIsAutoColorEnabled) {
                this.mUnitTextPaint.setColor(this.calcTextColor(this.mCurrentValue));
            }
            if (update) {
                if (this.mIsAutoTextSize) {
                    this.setUnitTextBoundsAndSizeWithAutoTextSize(unitGapWidthHalf, unitWidth, unitGapHeightHalf, unitHeight);
                } else {
                    this.setUnitTextBoundsAndSizeWithFixedTextSize(unitGapWidthHalf * 2.0f, unitGapHeightHalf * 2.0f);
                }
            }
            canvas.drawText(this.mUnit, this.mUnitBounds.left - this.mUnitTextPaint.getTextSize() * 0.02f, this.mUnitBounds.bottom, this.mUnitTextPaint);
        }
    }

    private void drawBar(Canvas _canvas, float _degrees) {
        float startAngle;
        float f = startAngle = this.mDirection == Direction.CW ? (float)this.mStartAngle : (float)this.mStartAngle - _degrees;
        if (!this.mShowBlock) {
            if (this.mBarStrokeCap != Paint.Cap.BUTT && _degrees > 0.0f && this.mBarColors.length > 1) {
                if (_degrees > 180.0f) {
                    _canvas.drawArc(this.mCircleBounds, startAngle, _degrees / 2.0f, false, this.mBarPaint);
                    _canvas.drawArc(this.mCircleBounds, startAngle, 1.0f, false, this.mShaderlessBarPaint);
                    _canvas.drawArc(this.mCircleBounds, startAngle + _degrees / 2.0f, _degrees / 2.0f, false, this.mBarPaint);
                } else {
                    _canvas.drawArc(this.mCircleBounds, startAngle, _degrees, false, this.mBarPaint);
                    _canvas.drawArc(this.mCircleBounds, startAngle, 1.0f, false, this.mShaderlessBarPaint);
                }
            } else {
                _canvas.drawArc(this.mCircleBounds, startAngle, _degrees, false, this.mBarPaint);
            }
        } else {
            this.drawBlocks(_canvas, this.mCircleBounds, startAngle, _degrees, false, this.mBarPaint);
        }
    }

    public void stopSpinning() {
        this.setSpin(false);
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.STOP_SPINNING.ordinal());
    }

    public void spin() {
        this.setSpin(true);
        this.mAnimationHandler.sendEmptyMessage(AnimationMsg.START_SPINNING.ordinal());
    }

    private void setSpin(boolean spin) {
        this.mSpin = spin;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.mSeekModeEnabled) {
            return super.onTouchEvent(event);
        }
        switch (event.getActionMasked()) {
            case 0: 
            case 1: {
                this.mTouchEventCount = 0;
                PointF point = new PointF(event.getX(), event.getY());
                float angle = this.getRotationAngleForPointFromStart(point);
                this.setValueAnimated(this.mMaxValue / 360.0f * angle, 800L);
                return true;
            }
            case 2: {
                ++this.mTouchEventCount;
                if (this.mTouchEventCount > 5) {
                    PointF point = new PointF(event.getX(), event.getY());
                    float angle = this.getRotationAngleForPointFromStart(point);
                    this.setValue(this.mMaxValue / 360.0f * angle);
                    return true;
                }
                return false;
            }
            case 3: {
                this.mTouchEventCount = 0;
                return false;
            }
        }
        return super.onTouchEvent(event);
    }

    private float getRotationAngleForPointFromStart(PointF point) {
        long angle = Math.round(CircleProgressView.calcRotationAngleInDegrees(this.mCenter, point));
        float fromStart = this.mDirection == Direction.CW ? (float)(angle - (long)this.mStartAngle) : (float)((long)this.mStartAngle - angle);
        return CircleProgressView.normalizeAngle(fromStart);
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(float var1);
    }
}

