/*
 * Decompiled with CFR 0.152.
 */
package at.grabner.circleprogress;

import android.animation.TimeInterpolator;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import at.grabner.circleprogress.AnimationMsg;
import at.grabner.circleprogress.AnimationState;
import at.grabner.circleprogress.CircleProgressView;
import java.lang.ref.WeakReference;

public class AnimationHandler
extends Handler {
    private final WeakReference<CircleProgressView> mCircleViewWeakReference;
    private float mSpinningBarLengthStart;
    private long mAnimationStartTime;
    private long mLengthChangeAnimationStartTime;
    private TimeInterpolator mLengthChangeInterpolator = new DecelerateInterpolator();
    private TimeInterpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private double mLengthChangeAnimationDuration;
    private long mFrameStartTime = 0L;

    AnimationHandler(CircleProgressView circleView) {
        super(circleView.getContext().getMainLooper());
        this.mCircleViewWeakReference = new WeakReference<CircleProgressView>(circleView);
    }

    public void setValueInterpolator(TimeInterpolator mInterpolator) {
        this.mInterpolator = mInterpolator;
    }

    public void setLengthChangeInterpolator(TimeInterpolator mLengthChangeInterpolator) {
        this.mLengthChangeInterpolator = mLengthChangeInterpolator;
    }

    public void handleMessage(Message msg) {
        CircleProgressView circleView = (CircleProgressView)((Object)this.mCircleViewWeakReference.get());
        if (circleView == null) {
            return;
        }
        AnimationMsg msgType = AnimationMsg.values()[msg.what];
        if (msgType == AnimationMsg.TICK) {
            this.removeMessages(AnimationMsg.TICK.ordinal());
        }
        this.mFrameStartTime = SystemClock.uptimeMillis();
        block0 : switch (circleView.mAnimationState) {
            case IDLE: {
                switch (msgType) {
                    case START_SPINNING: {
                        this.enterSpinning(circleView);
                        break;
                    }
                    case STOP_SPINNING: {
                        break;
                    }
                    case SET_VALUE: {
                        this.setValue(msg, circleView);
                        break;
                    }
                    case SET_VALUE_ANIMATED: {
                        this.enterSetValueAnimated(msg, circleView);
                        break;
                    }
                    case TICK: {
                        this.removeMessages(AnimationMsg.TICK.ordinal());
                    }
                }
                break;
            }
            case SPINNING: {
                switch (msgType) {
                    case START_SPINNING: {
                        break;
                    }
                    case STOP_SPINNING: {
                        this.enterEndSpinning(circleView);
                        break;
                    }
                    case SET_VALUE: {
                        this.setValue(msg, circleView);
                        break;
                    }
                    case SET_VALUE_ANIMATED: {
                        this.enterEndSpinningStartAnimating(circleView, msg);
                        break;
                    }
                    case TICK: {
                        float length_delta = circleView.mSpinningBarLengthCurrent - circleView.mSpinningBarLengthOrig;
                        float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                        t = t > 1.0f ? 1.0f : t;
                        float interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                        circleView.mSpinningBarLengthCurrent = Math.abs(length_delta) < 1.0f ? circleView.mSpinningBarLengthOrig : (circleView.mSpinningBarLengthCurrent < circleView.mSpinningBarLengthOrig ? this.mSpinningBarLengthStart + (circleView.mSpinningBarLengthOrig - this.mSpinningBarLengthStart) * interpolatedRatio : this.mSpinningBarLengthStart - (this.mSpinningBarLengthStart - circleView.mSpinningBarLengthOrig) * interpolatedRatio);
                        circleView.mCurrentSpinnerDegreeValue += circleView.mSpinSpeed;
                        if (circleView.mCurrentSpinnerDegreeValue > 360.0f) {
                            circleView.mCurrentSpinnerDegreeValue = 0.0f;
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        circleView.invalidate();
                    }
                }
                break;
            }
            case END_SPINNING: {
                switch (msgType) {
                    case START_SPINNING: {
                        circleView.mAnimationState = AnimationState.SPINNING;
                        if (circleView.mAnimationStateChangedListener != null) {
                            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        break;
                    }
                    case STOP_SPINNING: {
                        break;
                    }
                    case SET_VALUE: {
                        this.setValue(msg, circleView);
                        break;
                    }
                    case SET_VALUE_ANIMATED: {
                        this.enterEndSpinningStartAnimating(circleView, msg);
                        break;
                    }
                    case TICK: {
                        float t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                        t = t > 1.0f ? 1.0f : t;
                        float interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                        circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                        circleView.mCurrentSpinnerDegreeValue += circleView.mSpinSpeed;
                        if (circleView.mSpinningBarLengthCurrent < 0.01f) {
                            circleView.mAnimationState = AnimationState.IDLE;
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                            }
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        circleView.invalidate();
                    }
                }
                break;
            }
            case END_SPINNING_START_ANIMATING: {
                switch (msgType) {
                    case START_SPINNING: {
                        circleView.mDrawBarWhileSpinning = false;
                        this.enterSpinning(circleView);
                        break;
                    }
                    case STOP_SPINNING: {
                        break;
                    }
                    case SET_VALUE: {
                        circleView.mDrawBarWhileSpinning = false;
                        this.setValue(msg, circleView);
                        break;
                    }
                    case SET_VALUE_ANIMATED: {
                        circleView.mValueFrom = 0.0f;
                        circleView.mValueTo = ((float[])msg.obj)[1];
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        break;
                    }
                    case TICK: {
                        float interpolatedRatio;
                        float t;
                        if (circleView.mSpinningBarLengthCurrent > circleView.mSpinningBarLengthOrig && !circleView.mDrawBarWhileSpinning) {
                            t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                            t = t > 1.0f ? 1.0f : t;
                            interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                            circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                        }
                        circleView.mCurrentSpinnerDegreeValue += circleView.mSpinSpeed;
                        if (circleView.mCurrentSpinnerDegreeValue > 360.0f && !circleView.mDrawBarWhileSpinning) {
                            this.mAnimationStartTime = System.currentTimeMillis();
                            circleView.mDrawBarWhileSpinning = true;
                            this.initReduceAnimation(circleView);
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(AnimationState.START_ANIMATING_AFTER_SPINNING);
                            }
                        }
                        if (circleView.mDrawBarWhileSpinning) {
                            circleView.mCurrentSpinnerDegreeValue = 360.0f;
                            circleView.mSpinningBarLengthCurrent -= circleView.mSpinSpeed;
                            this.calcNextAnimationValue(circleView);
                            t = (float)((double)(System.currentTimeMillis() - this.mLengthChangeAnimationStartTime) / this.mLengthChangeAnimationDuration);
                            t = t > 1.0f ? 1.0f : t;
                            interpolatedRatio = this.mLengthChangeInterpolator.getInterpolation(t);
                            circleView.mSpinningBarLengthCurrent = this.mSpinningBarLengthStart * (1.0f - interpolatedRatio);
                        }
                        if ((double)circleView.mSpinningBarLengthCurrent < 0.1) {
                            circleView.mAnimationState = AnimationState.ANIMATING;
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                            }
                            circleView.invalidate();
                            circleView.mDrawBarWhileSpinning = false;
                            circleView.mSpinningBarLengthCurrent = circleView.mSpinningBarLengthOrig;
                        } else {
                            circleView.invalidate();
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                    }
                }
                break;
            }
            case ANIMATING: {
                switch (msgType) {
                    case START_SPINNING: {
                        this.enterSpinning(circleView);
                        break block0;
                    }
                    case STOP_SPINNING: {
                        break block0;
                    }
                    case SET_VALUE: {
                        this.setValue(msg, circleView);
                        break block0;
                    }
                    case SET_VALUE_ANIMATED: {
                        this.mAnimationStartTime = System.currentTimeMillis();
                        circleView.mValueFrom = circleView.mCurrentValue;
                        circleView.mValueTo = ((float[])msg.obj)[1];
                        break block0;
                    }
                    case TICK: {
                        if (this.calcNextAnimationValue(circleView)) {
                            circleView.mAnimationState = AnimationState.IDLE;
                            if (circleView.mAnimationStateChangedListener != null) {
                                circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
                            }
                            circleView.mCurrentValue = circleView.mValueTo;
                        }
                        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
                        circleView.invalidate();
                    }
                }
            }
        }
    }

    private void enterSetValueAnimated(Message msg, CircleProgressView circleView) {
        circleView.mValueFrom = ((float[])msg.obj)[0];
        circleView.mValueTo = ((float[])msg.obj)[1];
        this.mAnimationStartTime = System.currentTimeMillis();
        circleView.mAnimationState = AnimationState.ANIMATING;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
    }

    private void enterEndSpinningStartAnimating(CircleProgressView circleView, Message msg) {
        circleView.mAnimationState = AnimationState.END_SPINNING_START_ANIMATING;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        circleView.mValueFrom = 0.0f;
        circleView.mValueTo = ((float[])msg.obj)[1];
        this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
        this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
    }

    private void enterEndSpinning(CircleProgressView circleView) {
        circleView.mAnimationState = AnimationState.END_SPINNING;
        this.initReduceAnimation(circleView);
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
    }

    private void initReduceAnimation(CircleProgressView circleView) {
        float degreesTillFinish = circleView.mSpinningBarLengthCurrent;
        float stepsTillFinish = degreesTillFinish / circleView.mSpinSpeed;
        this.mLengthChangeAnimationDuration = stepsTillFinish * (float)circleView.mFrameDelayMillis * 2.0f;
        this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
        this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
    }

    private void enterSpinning(CircleProgressView circleView) {
        circleView.mAnimationState = AnimationState.SPINNING;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        circleView.mSpinningBarLengthCurrent = 360.0f / circleView.mMaxValue * circleView.mCurrentValue;
        circleView.mCurrentSpinnerDegreeValue = 360.0f / circleView.mMaxValue * circleView.mCurrentValue;
        this.mLengthChangeAnimationStartTime = System.currentTimeMillis();
        this.mSpinningBarLengthStart = circleView.mSpinningBarLengthCurrent;
        float stepsTillFinish = circleView.mSpinningBarLengthOrig / circleView.mSpinSpeed;
        this.mLengthChangeAnimationDuration = stepsTillFinish * (float)circleView.mFrameDelayMillis * 2.0f;
        this.sendEmptyMessageDelayed(AnimationMsg.TICK.ordinal(), (long)circleView.mFrameDelayMillis - (SystemClock.uptimeMillis() - this.mFrameStartTime));
    }

    private boolean calcNextAnimationValue(CircleProgressView circleView) {
        float t = (float)((double)(System.currentTimeMillis() - this.mAnimationStartTime) / circleView.mAnimationDuration);
        t = t > 1.0f ? 1.0f : t;
        float interpolatedRatio = this.mInterpolator.getInterpolation(t);
        circleView.mCurrentValue = circleView.mValueFrom + (circleView.mValueTo - circleView.mValueFrom) * interpolatedRatio;
        return t >= 1.0f;
    }

    private void setValue(Message msg, CircleProgressView circleView) {
        circleView.mValueFrom = circleView.mValueTo;
        circleView.mCurrentValue = circleView.mValueTo = ((float[])msg.obj)[0];
        circleView.mAnimationState = AnimationState.IDLE;
        if (circleView.mAnimationStateChangedListener != null) {
            circleView.mAnimationStateChangedListener.onAnimationStateChanged(circleView.mAnimationState);
        }
        circleView.invalidate();
    }
}

