/*
 * Decompiled with CFR 0.152.
 */
package com.github.jakemarsden.githooksgradleplugin;

import com.github.jakemarsden.githooksgradleplugin.GitHookWriter;
import com.github.jakemarsden.githooksgradleplugin.GitHooksExtension;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class GitHooksPlugin
implements Plugin<Project> {
    private static final Set<String> VALID_HOOKS;

    public void apply(Project project) {
        GitHooksExtension extension = (GitHooksExtension)project.getExtensions().create("gitHooks", GitHooksExtension.class, new Object[0]);
        project.afterEvaluate(p -> this.writeHooks(extension));
    }

    private void writeHooks(GitHooksExtension extension) {
        Map<String, String> hooks = extension.finalizeHooks();
        Path hooksDirectory = extension.finalizeHooksDirectory().getAsFile().toPath();
        String gradleCommand = extension.finalizeGradleCommand();
        GitHookWriter writer = new GitHookWriter(hooksDirectory, gradleCommand);
        this.validateHooks(hooks);
        hooks.forEach(writer::writeHook);
    }

    private void validateHooks(Map<String, String> hooks) {
        if (hooks.isEmpty()) {
            throw new IllegalArgumentException("No hooks found");
        }
        Set invalidHooks = hooks.keySet().stream().filter(hook -> !VALID_HOOKS.contains(hook)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        if (!invalidHooks.isEmpty()) {
            throw new IllegalArgumentException("Unsupported hook(s): " + invalidHooks);
        }
    }

    static {
        HashSet<String> validHooks = new HashSet<String>();
        validHooks.add("applypatch-msg");
        validHooks.add("commit-msg");
        validHooks.add("fsmonitor-watchman");
        validHooks.add("post-applypatch");
        validHooks.add("post-checkout");
        validHooks.add("post-commit");
        validHooks.add("post-merge");
        validHooks.add("post-receive");
        validHooks.add("post-rewrite");
        validHooks.add("post-update");
        validHooks.add("pre-applypatch");
        validHooks.add("pre-auto-gc");
        validHooks.add("pre-commit");
        validHooks.add("pre-push");
        validHooks.add("pre-rebase");
        validHooks.add("pre-receive");
        validHooks.add("prepare-commit-msg");
        validHooks.add("push-to-checkout");
        validHooks.add("update");
        validHooks.add("sendemail-validate");
        VALID_HOOKS = Collections.unmodifiableSet(validHooks);
    }
}

