/*
 * Decompiled with CFR 0.152.
 */
package cn.iwgang.countdownview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import cn.iwgang.countdownview.BackgroundCountdown;
import cn.iwgang.countdownview.BaseCountdown;
import cn.iwgang.countdownview.CustomCountDownTimer;
import cn.iwgang.countdownview.DynamicConfig;
import cn.iwgang.countdownview.R;

public class CountdownView
extends View {
    private BaseCountdown mCountdown;
    private CustomCountDownTimer mCustomCountDownTimer;
    private OnCountdownEndListener mOnCountdownEndListener;
    private OnCountdownIntervalListener mOnCountdownIntervalListener;
    private boolean isHideTimeBackground;
    private long mPreviousIntervalCallbackTime;
    private long mInterval;
    private long mRemainTime;

    public CountdownView(Context context) {
        this(context, null);
    }

    public CountdownView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CountdownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CountdownView);
        this.isHideTimeBackground = ta.getBoolean(R.styleable.CountdownView_isHideTimeBackground, true);
        this.mCountdown = this.isHideTimeBackground ? new BaseCountdown() : new BackgroundCountdown();
        this.mCountdown.initStyleAttr(context, ta);
        ta.recycle();
        this.mCountdown.initialize();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int contentAllWidth = this.mCountdown.getAllContentWidth();
        int contentAllHeight = this.mCountdown.getAllContentHeight();
        int viewWidth = this.measureSize(1, contentAllWidth, widthMeasureSpec);
        int viewHeight = this.measureSize(2, contentAllHeight, heightMeasureSpec);
        this.setMeasuredDimension(viewWidth, viewHeight);
        this.mCountdown.onMeasure(this, viewWidth, viewHeight, contentAllWidth, contentAllHeight);
    }

    private int measureSize(int specType, int contentSize, int measureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = Math.max(contentSize, specSize);
        } else {
            result = contentSize;
            result = specType == 1 ? (result += this.getPaddingLeft() + this.getPaddingRight()) : (result += this.getPaddingTop() + this.getPaddingBottom());
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mCountdown.onDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    private void reLayout() {
        this.mCountdown.reLayout();
        this.requestLayout();
    }

    public void start(long millisecond) {
        long countDownInterval;
        if (millisecond <= 0L) {
            return;
        }
        this.mPreviousIntervalCallbackTime = 0L;
        if (null != this.mCustomCountDownTimer) {
            this.mCustomCountDownTimer.stop();
            this.mCustomCountDownTimer = null;
        }
        if (this.mCountdown.isShowMillisecond) {
            countDownInterval = 10L;
            this.updateShow(millisecond);
        } else {
            countDownInterval = 1000L;
        }
        this.mCustomCountDownTimer = new CustomCountDownTimer(millisecond, countDownInterval){

            @Override
            public void onTick(long millisUntilFinished) {
                CountdownView.this.updateShow(millisUntilFinished);
            }

            @Override
            public void onFinish() {
                CountdownView.this.allShowZero();
                if (null != CountdownView.this.mOnCountdownEndListener) {
                    CountdownView.this.mOnCountdownEndListener.onEnd(CountdownView.this);
                }
            }
        };
        this.mCustomCountDownTimer.start();
    }

    public void stop() {
        if (null != this.mCustomCountDownTimer) {
            this.mCustomCountDownTimer.stop();
        }
    }

    public void pause() {
        if (null != this.mCustomCountDownTimer) {
            this.mCustomCountDownTimer.pause();
        }
    }

    public void restart() {
        if (null != this.mCustomCountDownTimer) {
            this.mCustomCountDownTimer.restart();
        }
    }

    @Deprecated
    public void customTimeShow(boolean isShowDay, boolean isShowHour, boolean isShowMinute, boolean isShowSecond, boolean isShowMillisecond) {
        this.mCountdown.mHasSetIsShowDay = true;
        this.mCountdown.mHasSetIsShowHour = true;
        boolean isModCountdownInterval = this.mCountdown.refTimeShow(isShowDay, isShowHour, isShowMinute, isShowSecond, isShowMillisecond);
        if (isModCountdownInterval) {
            this.start(this.mRemainTime);
        }
    }

    public void allShowZero() {
        this.mCountdown.setTimes(0, 0, 0, 0, 0);
        this.invalidate();
    }

    public void setOnCountdownEndListener(OnCountdownEndListener onCountdownEndListener) {
        this.mOnCountdownEndListener = onCountdownEndListener;
    }

    public void setOnCountdownIntervalListener(long interval, OnCountdownIntervalListener onCountdownIntervalListener) {
        this.mInterval = interval;
        this.mOnCountdownIntervalListener = onCountdownIntervalListener;
    }

    public int getDay() {
        return this.mCountdown.mDay;
    }

    public int getHour() {
        return this.mCountdown.mHour;
    }

    public int getMinute() {
        return this.mCountdown.mMinute;
    }

    public int getSecond() {
        return this.mCountdown.mSecond;
    }

    public long getRemainTime() {
        return this.mRemainTime;
    }

    public void updateShow(long ms) {
        this.mRemainTime = ms;
        this.reSetTime(ms);
        if (this.mInterval > 0L && null != this.mOnCountdownIntervalListener) {
            if (this.mPreviousIntervalCallbackTime == 0L) {
                this.mPreviousIntervalCallbackTime = ms;
            } else if (ms + this.mInterval <= this.mPreviousIntervalCallbackTime) {
                this.mPreviousIntervalCallbackTime = ms;
                this.mOnCountdownIntervalListener.onInterval(this, this.mRemainTime);
            }
        }
        if (this.mCountdown.handlerAutoShowTime() || this.mCountdown.handlerDayLargeNinetyNine()) {
            this.reLayout();
        } else {
            this.invalidate();
        }
    }

    private void reSetTime(long ms) {
        int hour;
        int day = 0;
        if (!this.mCountdown.isConvertDaysToHours) {
            day = (int)(ms / 86400000L);
            hour = (int)(ms % 86400000L / 3600000L);
        } else {
            hour = (int)(ms / 3600000L);
        }
        int minute = (int)(ms % 3600000L / 60000L);
        int second = (int)(ms % 60000L / 1000L);
        int millisecond = (int)(ms % 1000L);
        this.mCountdown.setTimes(day, hour, minute, second, millisecond);
    }

    public void dynamicShow(DynamicConfig dynamicConfig) {
        Boolean tempIsConvertDaysToHours;
        Integer suffixGravity;
        Float suffixMillisecondRightMargin;
        Float suffixSecondRightMargin;
        Float suffixSecondLeftMargin;
        Float suffixMinuteRightMargin;
        Float suffixMinuteLeftMargin;
        Float suffixHourRightMargin;
        Float suffixHourLeftMargin;
        Float suffixDayRightMargin;
        Float suffixDayLeftMargin;
        Float suffixLRMargin;
        String suffixMillisecond;
        String suffixSecond;
        String suffixMinute;
        String suffixHour;
        String suffixDay;
        String suffix;
        Boolean isSuffixTimeTextBold;
        Boolean isTimeTextBold;
        Integer suffixTextColor;
        Integer timeTextColor;
        Float suffixTextSize;
        if (null == dynamicConfig) {
            return;
        }
        boolean isReLayout = false;
        boolean isInvalidate = false;
        Float timeTextSize = dynamicConfig.getTimeTextSize();
        if (null != timeTextSize) {
            this.mCountdown.setTimeTextSize(timeTextSize.floatValue());
            isReLayout = true;
        }
        if (null != (suffixTextSize = dynamicConfig.getSuffixTextSize())) {
            this.mCountdown.setSuffixTextSize(suffixTextSize.floatValue());
            isReLayout = true;
        }
        if (null != (timeTextColor = dynamicConfig.getTimeTextColor())) {
            this.mCountdown.setTimeTextColor(timeTextColor);
            isInvalidate = true;
        }
        if (null != (suffixTextColor = dynamicConfig.getSuffixTextColor())) {
            this.mCountdown.setSuffixTextColor(suffixTextColor);
            isInvalidate = true;
        }
        if (null != (isTimeTextBold = dynamicConfig.isTimeTextBold())) {
            this.mCountdown.setTimeTextBold(isTimeTextBold);
            isReLayout = true;
        }
        if (null != (isSuffixTimeTextBold = dynamicConfig.isSuffixTimeTextBold())) {
            this.mCountdown.setSuffixTextBold(isSuffixTimeTextBold);
            isReLayout = true;
        }
        if (!TextUtils.isEmpty((CharSequence)(suffix = dynamicConfig.getSuffix()))) {
            this.mCountdown.setSuffix(suffix);
            isReLayout = true;
        }
        if (this.mCountdown.setSuffix(suffixDay = dynamicConfig.getSuffixDay(), suffixHour = dynamicConfig.getSuffixHour(), suffixMinute = dynamicConfig.getSuffixMinute(), suffixSecond = dynamicConfig.getSuffixSecond(), suffixMillisecond = dynamicConfig.getSuffixMillisecond())) {
            isReLayout = true;
        }
        if (null != (suffixLRMargin = dynamicConfig.getSuffixLRMargin())) {
            this.mCountdown.setSuffixLRMargin(suffixLRMargin.floatValue());
            isReLayout = true;
        }
        if (this.mCountdown.setSuffixMargin(suffixDayLeftMargin = dynamicConfig.getSuffixDayLeftMargin(), suffixDayRightMargin = dynamicConfig.getSuffixDayRightMargin(), suffixHourLeftMargin = dynamicConfig.getSuffixHourLeftMargin(), suffixHourRightMargin = dynamicConfig.getSuffixHourRightMargin(), suffixMinuteLeftMargin = dynamicConfig.getSuffixMinuteLeftMargin(), suffixMinuteRightMargin = dynamicConfig.getSuffixMinuteRightMargin(), suffixSecondLeftMargin = dynamicConfig.getSuffixSecondLeftMargin(), suffixSecondRightMargin = dynamicConfig.getSuffixSecondRightMargin(), suffixMillisecondRightMargin = dynamicConfig.getSuffixMillisecondLeftMargin())) {
            isReLayout = true;
        }
        if (null != (suffixGravity = dynamicConfig.getSuffixGravity())) {
            this.mCountdown.setSuffixGravity(suffixGravity);
            isReLayout = true;
        }
        Boolean tempIsShowDay = dynamicConfig.isShowDay();
        Boolean tempIsShowHour = dynamicConfig.isShowHour();
        Boolean tempIsShowMinute = dynamicConfig.isShowMinute();
        Boolean tempIsShowSecond = dynamicConfig.isShowSecond();
        Boolean tempIsShowMillisecond = dynamicConfig.isShowMillisecond();
        if (null != tempIsShowDay || null != tempIsShowHour || null != tempIsShowMinute || null != tempIsShowSecond || null != tempIsShowMillisecond) {
            boolean isShowDay = this.mCountdown.isShowDay;
            if (null != tempIsShowDay) {
                isShowDay = tempIsShowDay;
                this.mCountdown.mHasSetIsShowDay = true;
            } else {
                this.mCountdown.mHasSetIsShowDay = false;
            }
            boolean isShowHour = this.mCountdown.isShowHour;
            if (null != tempIsShowHour) {
                isShowHour = tempIsShowHour;
                this.mCountdown.mHasSetIsShowHour = true;
            } else {
                this.mCountdown.mHasSetIsShowHour = false;
            }
            boolean isShowMinute = null != tempIsShowMinute ? tempIsShowMinute : this.mCountdown.isShowMinute;
            boolean isShowSecond = null != tempIsShowSecond ? tempIsShowSecond : this.mCountdown.isShowSecond;
            boolean isShowMillisecond = null != tempIsShowMillisecond ? tempIsShowMillisecond : this.mCountdown.isShowMillisecond;
            boolean isModCountdownInterval = this.mCountdown.refTimeShow(isShowDay, isShowHour, isShowMinute, isShowSecond, isShowMillisecond);
            if (isModCountdownInterval) {
                this.start(this.mRemainTime);
            }
            isReLayout = true;
        }
        DynamicConfig.BackgroundInfo backgroundInfo = dynamicConfig.getBackgroundInfo();
        if (!this.isHideTimeBackground && null != backgroundInfo) {
            Boolean isShowTimeBgBorder;
            Boolean isShowTimeBgDivisionLine;
            Float radius;
            Integer color;
            BackgroundCountdown backgroundCountdown = (BackgroundCountdown)this.mCountdown;
            Float size = backgroundInfo.getSize();
            if (null != size) {
                backgroundCountdown.setTimeBgSize(size.floatValue());
                isReLayout = true;
            }
            if (null != (color = backgroundInfo.getColor())) {
                backgroundCountdown.setTimeBgColor(color);
                isInvalidate = true;
            }
            if (null != (radius = backgroundInfo.getRadius())) {
                backgroundCountdown.setTimeBgRadius(radius.floatValue());
                isInvalidate = true;
            }
            if (null != (isShowTimeBgDivisionLine = backgroundInfo.isShowTimeBgDivisionLine())) {
                backgroundCountdown.setIsShowTimeBgDivisionLine(isShowTimeBgDivisionLine);
                if (isShowTimeBgDivisionLine.booleanValue()) {
                    Float divisionLineSize;
                    Integer divisionLineColor = backgroundInfo.getDivisionLineColor();
                    if (null != divisionLineColor) {
                        backgroundCountdown.setTimeBgDivisionLineColor(divisionLineColor);
                    }
                    if (null != (divisionLineSize = backgroundInfo.getDivisionLineSize())) {
                        backgroundCountdown.setTimeBgDivisionLineSize(divisionLineSize.floatValue());
                    }
                }
                isInvalidate = true;
            }
            if (null != (isShowTimeBgBorder = backgroundInfo.isShowTimeBgBorder())) {
                backgroundCountdown.setIsShowTimeBgBorder(isShowTimeBgBorder);
                if (isShowTimeBgBorder.booleanValue()) {
                    Float borderRadius;
                    Float borderSize;
                    Integer borderColor = backgroundInfo.getBorderColor();
                    if (null != borderColor) {
                        backgroundCountdown.setTimeBgBorderColor(borderColor);
                    }
                    if (null != (borderSize = backgroundInfo.getBorderSize())) {
                        backgroundCountdown.setTimeBgBorderSize(borderSize.floatValue());
                    }
                    if (null != (borderRadius = backgroundInfo.getBorderRadius())) {
                        backgroundCountdown.setTimeBgBorderRadius(borderRadius.floatValue());
                    }
                }
                isReLayout = true;
            }
        }
        if (null != (tempIsConvertDaysToHours = dynamicConfig.isConvertDaysToHours()) && this.mCountdown.setConvertDaysToHours(tempIsConvertDaysToHours)) {
            this.reSetTime(this.getRemainTime());
            isReLayout = true;
        }
        if (isReLayout) {
            this.reLayout();
        } else if (isInvalidate) {
            this.invalidate();
        }
    }

    public static interface OnCountdownIntervalListener {
        public void onInterval(CountdownView var1, long var2);
    }

    public static interface OnCountdownEndListener {
        public void onEnd(CountdownView var1);
    }
}

