/*
 * Decompiled with CFR 0.152.
 */
package com.ittianyu.bottomnavigationviewex;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.design.R;
import android.support.design.internal.BottomNavigationItemView;
import android.support.design.internal.BottomNavigationMenuView;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.widget.BottomNavigationView;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

@SuppressLint(value={"RestrictedApi"})
public class BottomNavigationViewInner
extends BottomNavigationView {
    private float mShiftAmount;
    private float mScaleUpFactor;
    private float mScaleDownFactor;
    private boolean animationRecord;
    private float mLargeLabelSize;
    private float mSmallLabelSize;
    private boolean visibilityTextSizeRecord;
    private boolean visibilityHeightRecord;
    private int mItemHeight;
    private boolean textVisibility = true;
    private ViewPager mViewPager;
    private MyOnNavigationItemSelectedListener mMyOnNavigationItemSelectedListener;
    private BottomNavigationViewExOnPageChangeListener mPageChangeListener;
    private BottomNavigationMenuView mMenuView;
    private BottomNavigationItemView[] mButtons;
    private static boolean isNavigationItemClicking = false;

    public BottomNavigationViewInner(Context context) {
        this(context, null);
    }

    public BottomNavigationViewInner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationViewInner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TintTypedArray a = ThemeEnforcement.obtainTintedStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.BottomNavigationView, (int)defStyleAttr, (int)R.style.Widget_Design_BottomNavigationView, (int[])new int[]{R.styleable.BottomNavigationView_itemTextAppearanceInactive, R.styleable.BottomNavigationView_itemTextAppearanceActive});
        if (!a.hasValue(R.styleable.BottomNavigationView_itemIconTint)) {
            this.clearIconTintColor();
        }
        a.recycle();
    }

    public BottomNavigationViewInner setIconVisibility(boolean visibility) {
        BottomNavigationItemView[] mButtons;
        BottomNavigationMenuView mMenuView = this.getBottomNavigationMenuView();
        for (BottomNavigationItemView button : mButtons = this.getBottomNavigationItemViews()) {
            ImageView mIcon = (ImageView)this.getField(button.getClass(), button, "icon");
            mIcon.setVisibility(visibility ? 0 : 4);
        }
        if (!visibility) {
            ImageView mIcon;
            BottomNavigationItemView button;
            if (!this.visibilityHeightRecord) {
                this.visibilityHeightRecord = true;
                this.mItemHeight = this.getItemHeight();
            }
            if (null != (button = mButtons[0]) && null != (mIcon = (ImageView)this.getField(button.getClass(), button, "icon"))) {
                mIcon.post(new Runnable(){

                    @Override
                    public void run() {
                        BottomNavigationViewInner.this.setItemHeight(BottomNavigationViewInner.this.mItemHeight - mIcon.getMeasuredHeight());
                    }
                });
            }
        } else {
            if (!this.visibilityHeightRecord) {
                return this;
            }
            this.setItemHeight(this.mItemHeight);
        }
        mMenuView.updateMenuView();
        return this;
    }

    public BottomNavigationViewInner setTextVisibility(boolean visibility) {
        BottomNavigationItemView[] mButtons;
        this.textVisibility = visibility;
        BottomNavigationMenuView mMenuView = this.getBottomNavigationMenuView();
        for (BottomNavigationItemView button : mButtons = this.getBottomNavigationItemViews()) {
            TextView mLargeLabel = (TextView)this.getField(button.getClass(), button, "largeLabel");
            TextView mSmallLabel = (TextView)this.getField(button.getClass(), button, "smallLabel");
            if (!visibility) {
                if (!this.visibilityTextSizeRecord && !this.animationRecord) {
                    this.visibilityTextSizeRecord = true;
                    this.mLargeLabelSize = mLargeLabel.getTextSize();
                    this.mSmallLabelSize = mSmallLabel.getTextSize();
                }
                mLargeLabel.setTextSize(0, 0.0f);
                mSmallLabel.setTextSize(0, 0.0f);
                continue;
            }
            if (!this.visibilityTextSizeRecord) break;
            mLargeLabel.setTextSize(0, this.mLargeLabelSize);
            mSmallLabel.setTextSize(0, this.mSmallLabelSize);
        }
        if (!visibility) {
            if (!this.visibilityHeightRecord) {
                this.visibilityHeightRecord = true;
                this.mItemHeight = this.getItemHeight();
            }
            this.setItemHeight(this.mItemHeight - BottomNavigationViewInner.getFontHeight(this.mSmallLabelSize));
        } else {
            if (!this.visibilityHeightRecord) {
                return this;
            }
            this.setItemHeight(this.mItemHeight);
        }
        mMenuView.updateMenuView();
        return this;
    }

    private static int getFontHeight(float fontSize) {
        Paint paint = new Paint();
        paint.setTextSize(fontSize);
        Paint.FontMetrics fm = paint.getFontMetrics();
        return (int)Math.ceil(fm.descent - fm.top) + 2;
    }

    public BottomNavigationViewInner enableAnimation(boolean enable) {
        BottomNavigationItemView[] mButtons;
        BottomNavigationMenuView mMenuView = this.getBottomNavigationMenuView();
        for (BottomNavigationItemView button : mButtons = this.getBottomNavigationItemViews()) {
            TextView mLargeLabel = (TextView)this.getField(button.getClass(), button, "largeLabel");
            TextView mSmallLabel = (TextView)this.getField(button.getClass(), button, "smallLabel");
            if (!enable) {
                if (!this.animationRecord) {
                    this.animationRecord = true;
                    this.mShiftAmount = ((Float)this.getField(button.getClass(), button, "shiftAmount")).floatValue();
                    this.mScaleUpFactor = ((Float)this.getField(button.getClass(), button, "scaleUpFactor")).floatValue();
                    this.mScaleDownFactor = ((Float)this.getField(button.getClass(), button, "scaleDownFactor")).floatValue();
                    this.mLargeLabelSize = mLargeLabel.getTextSize();
                    this.mSmallLabelSize = mSmallLabel.getTextSize();
                }
                this.setField(button.getClass(), button, "shiftAmount", 0);
                this.setField(button.getClass(), button, "scaleUpFactor", 1);
                this.setField(button.getClass(), button, "scaleDownFactor", 1);
                mLargeLabel.setTextSize(0, this.mSmallLabelSize);
                continue;
            }
            if (!this.animationRecord) {
                return this;
            }
            this.setField(button.getClass(), button, "shiftAmount", Float.valueOf(this.mShiftAmount));
            this.setField(button.getClass(), button, "scaleUpFactor", Float.valueOf(this.mScaleUpFactor));
            this.setField(button.getClass(), button, "scaleDownFactor", Float.valueOf(this.mScaleDownFactor));
            mLargeLabel.setTextSize(0, this.mLargeLabelSize);
        }
        mMenuView.updateMenuView();
        return this;
    }

    @Deprecated
    public BottomNavigationViewInner enableShiftingMode(boolean enable) {
        this.setLabelVisibilityMode(enable ? 0 : 1);
        return this;
    }

    @Deprecated
    public BottomNavigationViewInner enableItemShiftingMode(boolean enable) {
        this.setItemHorizontalTranslationEnabled(enable);
        return this;
    }

    public int getCurrentItem() {
        BottomNavigationItemView[] mButtons = this.getBottomNavigationItemViews();
        Menu menu = this.getMenu();
        for (int i = 0; i < mButtons.length; ++i) {
            if (!menu.getItem(i).isChecked()) continue;
            return i;
        }
        return 0;
    }

    public int getMenuItemPosition(MenuItem item) {
        int itemId = item.getItemId();
        Menu menu = this.getMenu();
        int size = menu.size();
        for (int i = 0; i < size; ++i) {
            if (menu.getItem(i).getItemId() != itemId) continue;
            return i;
        }
        return -1;
    }

    public BottomNavigationViewInner setCurrentItem(int index) {
        this.setSelectedItemId(this.getMenu().getItem(index).getItemId());
        return this;
    }

    public BottomNavigationView.OnNavigationItemSelectedListener getOnNavigationItemSelectedListener() {
        BottomNavigationView.OnNavigationItemSelectedListener mListener = (BottomNavigationView.OnNavigationItemSelectedListener)this.getField(BottomNavigationView.class, (Object)this, "selectedListener");
        return mListener;
    }

    public void setOnNavigationItemSelectedListener(BottomNavigationView.OnNavigationItemSelectedListener listener) {
        if (null == this.mMyOnNavigationItemSelectedListener) {
            super.setOnNavigationItemSelectedListener(listener);
            return;
        }
        this.mMyOnNavigationItemSelectedListener.setOnNavigationItemSelectedListener(listener);
    }

    public BottomNavigationMenuView getBottomNavigationMenuView() {
        if (null == this.mMenuView) {
            this.mMenuView = (BottomNavigationMenuView)this.getField(BottomNavigationView.class, (Object)this, "menuView");
        }
        return this.mMenuView;
    }

    public BottomNavigationViewInner clearIconTintColor() {
        this.getBottomNavigationMenuView().setIconTintList(null);
        return this;
    }

    public BottomNavigationItemView[] getBottomNavigationItemViews() {
        if (null != this.mButtons) {
            return this.mButtons;
        }
        BottomNavigationMenuView mMenuView = this.getBottomNavigationMenuView();
        this.mButtons = (BottomNavigationItemView[])this.getField(mMenuView.getClass(), mMenuView, "buttons");
        return this.mButtons;
    }

    public BottomNavigationItemView getBottomNavigationItemView(int position) {
        return this.getBottomNavigationItemViews()[position];
    }

    public ImageView getIconAt(int position) {
        BottomNavigationItemView mButtons = this.getBottomNavigationItemView(position);
        ImageView mIcon = (ImageView)this.getField(BottomNavigationItemView.class, mButtons, "icon");
        return mIcon;
    }

    public TextView getSmallLabelAt(int position) {
        BottomNavigationItemView mButtons = this.getBottomNavigationItemView(position);
        TextView mSmallLabel = (TextView)this.getField(BottomNavigationItemView.class, mButtons, "smallLabel");
        return mSmallLabel;
    }

    public TextView getLargeLabelAt(int position) {
        BottomNavigationItemView mButtons = this.getBottomNavigationItemView(position);
        TextView mLargeLabel = (TextView)this.getField(BottomNavigationItemView.class, mButtons, "largeLabel");
        return mLargeLabel;
    }

    public int getItemCount() {
        BottomNavigationItemView[] bottomNavigationItemViews = this.getBottomNavigationItemViews();
        if (null == bottomNavigationItemViews) {
            return 0;
        }
        return bottomNavigationItemViews.length;
    }

    public BottomNavigationViewInner setSmallTextSize(float sp) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.getSmallLabelAt(i).setTextSize(sp);
        }
        this.mMenuView.updateMenuView();
        return this;
    }

    public BottomNavigationViewInner setLargeTextSize(float sp) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            TextView tvLarge = this.getLargeLabelAt(i);
            if (null == tvLarge) continue;
            tvLarge.setTextSize(sp);
        }
        this.mMenuView.updateMenuView();
        return this;
    }

    public BottomNavigationViewInner setTextSize(float sp) {
        this.setLargeTextSize(sp);
        this.setSmallTextSize(sp);
        return this;
    }

    public BottomNavigationViewInner setIconSizeAt(int position, float width, float height) {
        ImageView icon = this.getIconAt(position);
        ViewGroup.LayoutParams layoutParams = icon.getLayoutParams();
        layoutParams.width = BottomNavigationViewInner.dp2px(this.getContext(), width);
        layoutParams.height = BottomNavigationViewInner.dp2px(this.getContext(), height);
        icon.setLayoutParams(layoutParams);
        this.mMenuView.updateMenuView();
        return this;
    }

    public BottomNavigationViewInner setIconSize(float width, float height) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.setIconSizeAt(i, width, height);
        }
        return this;
    }

    public BottomNavigationViewInner setIconSize(float dpSize) {
        this.setItemIconSize(BottomNavigationViewInner.dp2px(this.getContext(), dpSize));
        return this;
    }

    public BottomNavigationViewInner setItemHeight(int height) {
        BottomNavigationMenuView mMenuView = this.getBottomNavigationMenuView();
        this.setField(mMenuView.getClass(), mMenuView, "itemHeight", height);
        mMenuView.updateMenuView();
        return this;
    }

    public int getItemHeight() {
        BottomNavigationMenuView mMenuView = this.getBottomNavigationMenuView();
        return (Integer)this.getField(mMenuView.getClass(), mMenuView, "itemHeight");
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public BottomNavigationViewInner setTypeface(Typeface typeface, int style2) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.getLargeLabelAt(i).setTypeface(typeface, style2);
            this.getSmallLabelAt(i).setTypeface(typeface, style2);
        }
        this.mMenuView.updateMenuView();
        return this;
    }

    public BottomNavigationViewInner setTypeface(Typeface typeface) {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.getLargeLabelAt(i).setTypeface(typeface);
            this.getSmallLabelAt(i).setTypeface(typeface);
        }
        this.mMenuView.updateMenuView();
        return this;
    }

    private <T> T getField(Class targetClass, Object instance, String fieldName) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setField(Class targetClass, Object instance, String fieldName, Object value) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public BottomNavigationViewInner setupWithViewPager(ViewPager viewPager) {
        return this.setupWithViewPager(viewPager, false);
    }

    public BottomNavigationViewInner setupWithViewPager(ViewPager viewPager, boolean smoothScroll) {
        if (this.mViewPager != null && this.mPageChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
        }
        if (null == viewPager) {
            this.mViewPager = null;
            super.setOnNavigationItemSelectedListener(null);
            return this;
        }
        this.mViewPager = viewPager;
        if (this.mPageChangeListener == null) {
            this.mPageChangeListener = new BottomNavigationViewExOnPageChangeListener(this);
        }
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
        BottomNavigationView.OnNavigationItemSelectedListener listener = this.getOnNavigationItemSelectedListener();
        this.mMyOnNavigationItemSelectedListener = new MyOnNavigationItemSelectedListener(viewPager, this, smoothScroll, listener);
        super.setOnNavigationItemSelectedListener((BottomNavigationView.OnNavigationItemSelectedListener)this.mMyOnNavigationItemSelectedListener);
        return this;
    }

    public BottomNavigationViewInner enableShiftingMode(int position, boolean enable) {
        this.getBottomNavigationItemView(position).setShifting(enable);
        return this;
    }

    public BottomNavigationViewInner setItemBackground(int position, int background) {
        this.getBottomNavigationItemView(position).setItemBackground(background);
        return this;
    }

    public BottomNavigationViewInner setIconTintList(int position, ColorStateList tint) {
        this.getBottomNavigationItemView(position).setIconTintList(tint);
        return this;
    }

    public BottomNavigationViewInner setTextTintList(int position, ColorStateList tint) {
        this.getBottomNavigationItemView(position).setTextColor(tint);
        return this;
    }

    public BottomNavigationViewInner setIconsMarginTop(int marginTop) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.setIconMarginTop(i, marginTop);
        }
        return this;
    }

    public BottomNavigationViewInner setIconMarginTop(int position, int marginTop) {
        BottomNavigationItemView itemView = this.getBottomNavigationItemView(position);
        this.setField(BottomNavigationItemView.class, itemView, "defaultMargin", marginTop);
        this.mMenuView.updateMenuView();
        return this;
    }

    private static class MyOnNavigationItemSelectedListener
    implements BottomNavigationView.OnNavigationItemSelectedListener {
        private BottomNavigationView.OnNavigationItemSelectedListener listener;
        private final WeakReference<ViewPager> viewPagerRef;
        private boolean smoothScroll;
        private SparseIntArray items;
        private int previousPosition = -1;

        MyOnNavigationItemSelectedListener(ViewPager viewPager, BottomNavigationViewInner bnve, boolean smoothScroll, BottomNavigationView.OnNavigationItemSelectedListener listener) {
            this.viewPagerRef = new WeakReference<ViewPager>(viewPager);
            this.listener = listener;
            this.smoothScroll = smoothScroll;
            Menu menu = bnve.getMenu();
            int size = menu.size();
            this.items = new SparseIntArray(size);
            for (int i = 0; i < size; ++i) {
                int itemId = menu.getItem(i).getItemId();
                this.items.put(itemId, i);
            }
        }

        public void setOnNavigationItemSelectedListener(BottomNavigationView.OnNavigationItemSelectedListener listener) {
            this.listener = listener;
        }

        public boolean onNavigationItemSelected(MenuItem item) {
            boolean bool;
            int position = this.items.get(item.getItemId());
            if (this.previousPosition == position) {
                return true;
            }
            if (null != this.listener && !(bool = this.listener.onNavigationItemSelected(item))) {
                return false;
            }
            ViewPager viewPager = (ViewPager)this.viewPagerRef.get();
            if (null == viewPager) {
                return false;
            }
            isNavigationItemClicking = true;
            viewPager.setCurrentItem(this.items.get(item.getItemId()), this.smoothScroll);
            isNavigationItemClicking = false;
            this.previousPosition = position;
            return true;
        }
    }

    private static class BottomNavigationViewExOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<BottomNavigationViewInner> mBnveRef;

        public BottomNavigationViewExOnPageChangeListener(BottomNavigationViewInner bnve) {
            this.mBnveRef = new WeakReference<BottomNavigationViewInner>(bnve);
        }

        public void onPageScrollStateChanged(int state) {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            BottomNavigationViewInner bnve = (BottomNavigationViewInner)((Object)this.mBnveRef.get());
            if (null != bnve && !isNavigationItemClicking) {
                bnve.setCurrentItem(position);
            }
        }
    }
}

