/*
 * Decompiled with CFR 0.152.
 */
package com.github.ithildir.liferay.mobile.windows;

import com.github.ithildir.liferay.mobile.windows.CSharpUtil;
import com.liferay.mobile.sdk.BaseBuilder;
import com.liferay.mobile.sdk.http.Action;
import com.liferay.mobile.sdk.http.Discovery;
import com.liferay.mobile.sdk.util.Validator;
import com.liferay.mobile.sdk.velocity.VelocityUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.tools.generic.EscapeTool;

public class WindowsSDKBuilder
extends BaseBuilder {
    protected static final String PACKAGE = "package";
    protected static final String STREAM = "STREAM";

    public void build(Discovery discovery, List<Action> actions, String packageName, int version, String filter, String destination) throws Exception {
        this.copyResource("windows", destination);
        this.generateService(discovery, actions, packageName, version, filter, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyJarResource(JarURLConnection jarConnection, File destinationDir) throws IOException {
        String jarConnectionEntryName = jarConnection.getEntryName();
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> enu = jarFile.entries();
        while (enu.hasMoreElements()) {
            JarEntry jarEntry = enu.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.startsWith(jarConnectionEntryName)) continue;
            String fileName = jarEntryName;
            if (fileName.startsWith(jarConnectionEntryName)) {
                fileName = fileName.substring(jarConnectionEntryName.length());
            }
            File file = new File(destinationDir, fileName);
            if (jarEntry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            InputStream is = null;
            try {
                is = jarFile.getInputStream(jarEntry);
                FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    protected void copyResource(String name, String destination) throws IOException {
        File destinationDir = new File(destination);
        destinationDir = new File(destinationDir.getAbsoluteFile(), '/' + name);
        URL sourceURL = ((Object)((Object)this)).getClass().getResource('/' + name);
        URLConnection sourceConnection = sourceURL.openConnection();
        if (sourceConnection instanceof JarURLConnection) {
            this.copyJarResource((JarURLConnection)sourceConnection, destinationDir);
        } else {
            File sourceDir = new File(sourceURL.getPath());
            FileUtils.copyDirectory((File)sourceDir, (File)destinationDir);
        }
        Iterator itr = FileUtils.iterateFiles((File)destinationDir, (String[])new String[]{"copy"}, (boolean)true);
        while (itr.hasNext()) {
            File file = (File)itr.next();
            String cleanPath = FilenameUtils.removeExtension((String)file.getAbsolutePath());
            File cleanFile = new File(cleanPath);
            if (!cleanFile.exists()) {
                FileUtils.moveFile((File)file, (File)new File(cleanPath));
                continue;
            }
            file.delete();
        }
    }

    protected void generateService(Discovery discovery, List<Action> actions, String packageName, int version, String filter, String destination) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull((String)destination)) {
            sb.append(destination);
            if (!destination.endsWith("/")) {
                sb.append('/');
            }
        }
        sb.append("windows/Liferay.SDK/Service");
        destination = sb.toString();
        packageName = "Liferay.SDK.Service";
        VelocityContext context = this.getVelocityContext(discovery, actions, packageName, version, filter);
        String templatePath = "templates/windows/service.vm";
        String filePath = this.getServiceFilePath(context, version, destination, filter);
        VelocityUtil.generate((VelocityContext)context, (String)templatePath, (String)filePath, (boolean)true);
    }

    protected String getServiceFilePath(VelocityContext context, int version, String destination, String filter) {
        String className = (String)context.get("className");
        CSharpUtil cSharpUtil = (CSharpUtil)((Object)context.get("languageUtil"));
        StringBuilder sb = new StringBuilder();
        sb.append(destination);
        sb.append("/V");
        sb.append(version);
        sb.append('/');
        sb.append(cSharpUtil.getServicePackageName(filter));
        sb.append('/');
        File file = new File(sb.toString());
        file.mkdirs();
        sb.append(className);
        sb.append(".cs");
        return sb.toString();
    }

    protected VelocityContext getVelocityContext(Discovery discovery, List<Action> actions, String packageName, int version, String filter) {
        VelocityContext context = new VelocityContext();
        CSharpUtil cSharpUtil = new CSharpUtil();
        StringBuilder sb = new StringBuilder(packageName);
        sb.append(".V");
        sb.append(version);
        sb.append('.');
        sb.append(cSharpUtil.getServicePackageName(filter));
        packageName = sb.toString();
        context.put("className", (Object)cSharpUtil.getServiceClassName(filter));
        context.put("discovery", (Object)discovery);
        context.put("actions", actions);
        context.put("esc", (Object)new EscapeTool());
        context.put("JSON_OBJECT_WRAPPER", (Object)"JsonObjectWrapper");
        context.put("languageUtil", (Object)cSharpUtil);
        context.put(PACKAGE, (Object)packageName);
        context.put(STREAM, (Object)"Stream");
        context.put("VOID", (Object)"void");
        return context;
    }
}

